/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedInflightRepositoryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed InflightRepository")
public class ManagedInflightRepository
extends ManagedService
implements ManagedInflightRepositoryMBean {
    private final InflightRepository inflightRepository;

    public ManagedInflightRepository(CamelContext context, InflightRepository inflightRepository) {
        super(context, inflightRepository);
        this.inflightRepository = inflightRepository;
    }

    public InflightRepository getInflightRepository() {
        return this.inflightRepository;
    }

    @Override
    public int getSize() {
        return this.inflightRepository.size();
    }

    @Override
    public int size(String routeId) {
        return this.inflightRepository.size(routeId);
    }

    @Override
    public TabularData browse() {
        return this.browse(-1, false);
    }

    @Override
    public TabularData browse(int limit, boolean sortByLongestDuration) {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listInflightExchangesTabularType());
            Collection<InflightRepository.InflightExchange> exchanges = this.inflightRepository.browse(limit, sortByLongestDuration);
            for (InflightRepository.InflightExchange entry : exchanges) {
                CompositeType ct = CamelOpenMBeanTypes.listInflightExchangesCompositeType();
                String exchangeId = entry.getExchange().getExchangeId();
                String fromRouteId = entry.getExchange().getFromRouteId();
                String routeId = entry.getRouteId();
                String nodeId = entry.getNodeId();
                String elapsed = "" + entry.getElapsed();
                String duration = "" + entry.getDuration();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exchangeId", "fromRouteId", "routeId", "nodeId", "elapsed", "duration"}, new Object[]{exchangeId, fromRouteId, routeId, nodeId, elapsed, duration});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

