/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public abstract class QueryConsistencyException
extends QueryExecutionException
implements CoordinatorException {
    private final InetSocketAddress address;
    private final ConsistencyLevel consistency;
    private final int received;
    private final int required;

    protected QueryConsistencyException(InetSocketAddress address, String msg, ConsistencyLevel consistency, int received, int required) {
        super(msg);
        this.address = address;
        this.consistency = consistency;
        this.received = received;
        this.required = required;
    }

    protected QueryConsistencyException(InetSocketAddress address, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required) {
        super(msg, cause);
        this.address = address;
        this.consistency = consistency;
        this.received = received;
        this.required = required;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public int getReceivedAcknowledgements() {
        return this.received;
    }

    public int getRequiredAcknowledgements() {
        return this.required;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }
}

