/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;

public class EdmString
extends AbstractSimpleType {
    private static final Pattern PATTERN_ASCII = Pattern.compile("\\p{ASCII}*");
    private static final EdmString instance = new EdmString();

    public static EdmString getInstance() {
        return instance;
    }

    public Class<?> getDefaultType() {
        return String.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        String result;
        if (literalKind == EdmLiteralKind.URI) {
            if (value.length() < 2 || !value.startsWith("'") || !value.endsWith("'")) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
            result = value.substring(1, value.length() - 1).replace("''", "'");
        } else {
            result = value;
        }
        if (facets != null && (facets.isUnicode() != null && !facets.isUnicode().booleanValue() && !PATTERN_ASCII.matcher(result).matches() || facets.getMaxLength() != null && facets.getMaxLength() < result.length())) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}));
        }
        if (!returnType.isAssignableFrom(String.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
        return returnType.cast(result);
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        String result;
        String string = result = value instanceof String ? (String)value : String.valueOf(value);
        if (facets != null && (facets.isUnicode() != null && !facets.isUnicode().booleanValue() && !PATTERN_ASCII.matcher(result).matches() || facets.getMaxLength() != null && facets.getMaxLength() < result.length())) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}));
        }
        return result;
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        int length = literal.length();
        StringBuilder uriLiteral = new StringBuilder(length + 2);
        uriLiteral.append('\'');
        for (int i = 0; i < length; ++i) {
            char c = literal.charAt(i);
            if (c == '\'') {
                uriLiteral.append(c);
            }
            uriLiteral.append(c);
        }
        uriLiteral.append('\'');
        return uriLiteral.toString();
    }
}

