/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelException;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowException;
import org.apache.camel.component.servicenow.ServiceNowExceptionMapper;
import org.apache.camel.component.servicenow.ServiceNowParam;
import org.apache.camel.component.servicenow.auth.AuthenticationRequestFilter;
import org.apache.cxf.jaxrs.client.WebClient;

public class ServiceNowClient {
    private final ServiceNowConfiguration configuration;
    private final WebClient client;

    public ServiceNowClient(ServiceNowConfiguration configuration) throws Exception {
        this.configuration = configuration;
        this.client = WebClient.create((String)configuration.getApiUrl(), Arrays.asList(new AuthenticationRequestFilter(configuration), new JacksonJsonProvider(configuration.getMapper()), new ServiceNowExceptionMapper(configuration.getMapper())), (boolean)true);
        WebClient.getConfig((Object)this.client).getRequestContext().put("org.apache.cxf.http.header.split", true);
    }

    public ServiceNowClient types(MediaType type) {
        return this.types(type, type);
    }

    public ServiceNowClient types(MediaType accept, MediaType type) {
        this.client.accept(new MediaType[]{accept});
        this.client.type(type);
        return this;
    }

    public ServiceNowClient path(Object path) {
        if (path != null) {
            this.client.path(path);
        }
        return this;
    }

    public ServiceNowClient type(MediaType ct) {
        this.client.type(ct);
        return this;
    }

    public ServiceNowClient type(String type) {
        this.client.type(type);
        return this;
    }

    public ServiceNowClient accept(MediaType ... types) {
        this.client.accept(types);
        return this;
    }

    public ServiceNowClient accept(String ... types) {
        this.client.accept(types);
        return this;
    }

    public ServiceNowClient query(String name, Object ... values) {
        this.client.query(name, values);
        return this;
    }

    public ServiceNowClient query(ServiceNowParam param, Message message) {
        Object value = param.getHeaderValue(message, this.configuration);
        if (value != null) {
            this.client.query(param.getId(), new Object[]{value});
        }
        return this;
    }

    public Response invoke(String httpMethod) throws Exception {
        return this.invoke(httpMethod, null);
    }

    public Response invoke(String httpMethod, Object body) throws Exception {
        Response response = this.client.invoke(httpMethod, body);
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 201: 
            case 204: {
                break;
            }
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 415: {
                throw (ServiceNowException)((Object)response.readEntity(ServiceNowException.class));
            }
            default: {
                throw new CamelException(String.format("Status (%d): %s", code, response.readEntity(Map.class)));
            }
        }
        return response;
    }

    public ServiceNowClient reset() {
        this.client.back(true);
        this.client.reset();
        this.client.resetQuery();
        return this;
    }
}

