/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.servicenow.ServiceNowRelease;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class ServiceNowConfiguration
implements Cloneable {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    @UriParam(label="security", secret=true)
    @Metadata(required="true")
    private String userName;
    @UriParam(label="security", secret=true)
    @Metadata(required="true")
    private String password;
    @UriParam(label="security", secret=true)
    private String oauthClientId;
    @UriParam(label="security", secret=true)
    private String oauthClientSecret;
    @UriParam(label="security", secret=true)
    private String oauthTokenUrl;
    @UriParam(label="security")
    private String apiUrl;
    @UriParam(label="advanced")
    private String apiVersion;
    @UriParam
    private String resource;
    @UriParam
    private String table;
    @UriParam
    private Boolean excludeReferenceLink = false;
    @UriParam
    private Boolean suppressAutoSysField = false;
    @UriParam
    private Boolean includeScores = false;
    @UriParam
    private Boolean includeAggregates = false;
    @UriParam
    private Boolean includeAvailableBreakdowns = false;
    @UriParam
    private Boolean includeAvailableAggregates = false;
    @UriParam
    private Boolean includeScoreNotes = false;
    @UriParam
    private Boolean topLevelOnly;
    @UriParam
    private Boolean favorites;
    @UriParam
    private Boolean key;
    @UriParam
    private Boolean target;
    @UriParam(defaultValue="true", enums="false,true,all")
    private String display = "true";
    @UriParam(defaultValue="10")
    private Integer perPage = 10;
    @UriParam(enums="value,change,changeperc,gap,gapperc,duedate,name,order,default,group,indicator_group,frequency,target,date,trend,bullet,direction")
    private String sortBy;
    @UriParam(enums="asc,desc")
    private String sortDir;
    @UriParam
    private Boolean suppressPaginationHeader = false;
    @UriParam(defaultValue="false", enums="false,true,all")
    private String displayValue = "false";
    @UriParam
    private Boolean inputDisplayValue = false;
    @UriParam(prefix="request-model.", multiValue=true, javaType="java.lang.String")
    private Map<String, Class<?>> requestModels;
    @UriParam(prefix="response-model.", multiValue=true, javaType="java.lang.String")
    private Map<String, Class<?>> responseModels;
    @UriParam(label="advanced")
    private ObjectMapper mapper = MAPPER;
    @UriParam(defaultValue="HELSINKI", enums="FUJI,GENEVA,HELSINKI")
    private ServiceNowRelease release = ServiceNowRelease.HELSINKI;

    public String getUserName() {
        return this.userName;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public boolean hasApiUrl() {
        return this.apiUrl != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOauthClientId() {
        return this.oauthClientId;
    }

    public void setOauthClientId(String oauthClientId) {
        this.oauthClientId = oauthClientId;
    }

    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    public void setOauthClientSecret(String oauthClientSecret) {
        this.oauthClientSecret = oauthClientSecret;
    }

    public String getOauthTokenUrl() {
        return this.oauthTokenUrl;
    }

    public boolean hasOautTokenUrl() {
        return this.oauthTokenUrl != null;
    }

    public void setOauthTokenUrl(String oauthTokenUrl) {
        this.oauthTokenUrl = oauthTokenUrl;
    }

    public boolean hasBasicAuthentication() {
        return ObjectHelper.isNotEmpty((Object)this.userName) && ObjectHelper.isNotEmpty((Object)this.password);
    }

    public boolean hasOAuthAuthentication() {
        return ObjectHelper.isNotEmpty((Object)this.userName) && ObjectHelper.isNotEmpty((Object)this.password) && ObjectHelper.isNotEmpty((Object)this.oauthClientId) && ObjectHelper.isNotEmpty((Object)this.oauthClientSecret);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Boolean getExcludeReferenceLink() {
        return this.excludeReferenceLink;
    }

    public void setExcludeReferenceLink(Boolean excludeReferenceLink) {
        this.excludeReferenceLink = excludeReferenceLink;
    }

    public Boolean getSuppressAutoSysField() {
        return this.suppressAutoSysField;
    }

    public void setSuppressAutoSysField(Boolean suppressAutoSysField) {
        this.suppressAutoSysField = suppressAutoSysField;
    }

    public Boolean getSuppressPaginationHeader() {
        return this.suppressPaginationHeader;
    }

    public void setSuppressPaginationHeader(Boolean suppressPaginationHeader) {
        this.suppressPaginationHeader = suppressPaginationHeader;
    }

    public Boolean getIncludeScores() {
        return this.includeScores;
    }

    public void setIncludeScores(Boolean includeScores) {
        this.includeScores = includeScores;
    }

    public Boolean getIncludeAggregates() {
        return this.includeAggregates;
    }

    public void setIncludeAggregates(Boolean includeAggregates) {
        this.includeAggregates = includeAggregates;
    }

    public Boolean getIncludeAvailableBreakdowns() {
        return this.includeAvailableBreakdowns;
    }

    public void setIncludeAvailableBreakdowns(Boolean includeAvailableBreakdowns) {
        this.includeAvailableBreakdowns = includeAvailableBreakdowns;
    }

    public Boolean getIncludeAvailableAggregates() {
        return this.includeAvailableAggregates;
    }

    public void setIncludeAvailableAggregates(Boolean includeAvailableAggregates) {
        this.includeAvailableAggregates = includeAvailableAggregates;
    }

    public Boolean getIncludeScoreNotes() {
        return this.includeScoreNotes;
    }

    public void setIncludeScoreNotes(Boolean includeScoreNotes) {
        this.includeScoreNotes = includeScoreNotes;
    }

    public Boolean getFavorites() {
        return this.favorites;
    }

    public void setFavorites(Boolean favorites) {
        this.favorites = favorites;
    }

    public Boolean getKey() {
        return this.key;
    }

    public void setKey(Boolean key) {
        this.key = key;
    }

    public Boolean getTarget() {
        return this.target;
    }

    public void setTarget(Boolean target) {
        this.target = target;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Integer getPerPage() {
        return this.perPage;
    }

    public void setPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortDir() {
        return this.sortDir;
    }

    public void setSortDir(String sortDir) {
        this.sortDir = sortDir;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public Boolean getInputDisplayValue() {
        return this.inputDisplayValue;
    }

    public void setInputDisplayValue(Boolean inputDisplayValue) {
        this.inputDisplayValue = inputDisplayValue;
    }

    public Map<String, Class<?>> getRequestModels() {
        return this.requestModels;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public boolean hasMapper() {
        return this.mapper != null;
    }

    public void setRelease(ServiceNowRelease release) {
        this.release = release;
    }

    public ServiceNowRelease getRelease() {
        return this.release;
    }

    public Boolean getTopLevelOnly() {
        return this.topLevelOnly;
    }

    public void setTopLevelOnly(Boolean topLevelOnly) {
        this.topLevelOnly = topLevelOnly;
    }

    public void setModels(Map<String, Class<?>> models) {
        this.setRequestModels(models);
        this.setResponseModels(models);
    }

    public void addModel(String name, Class<?> type) {
        this.addRequestModel(name, type);
        this.addResponseModel(name, type);
    }

    public void setRequestModels(Map<String, Class<?>> models) {
        if (this.requestModels == null) {
            this.requestModels = new HashMap();
        }
        this.requestModels.clear();
        this.requestModels.putAll(models);
    }

    public void addRequestModel(String name, Class<?> type) {
        if (this.requestModels == null) {
            this.requestModels = new HashMap();
        }
        this.requestModels.put(name, type);
    }

    public Class<?> getRequestModel(String name) {
        return this.getRequestModel(name, null);
    }

    public Class<?> getRequestModel(String name, Class<?> defaultType) {
        Class<?> model = defaultType;
        if (this.requestModels != null && this.requestModels.containsKey(name)) {
            model = this.requestModels.get(name);
        }
        return model;
    }

    public void setResponseModels(Map<String, Class<?>> models) {
        if (this.responseModels == null) {
            this.responseModels = new HashMap();
        }
        this.responseModels.putAll(models);
    }

    public void addResponseModel(String name, Class<?> type) {
        if (this.responseModels == null) {
            this.responseModels = new HashMap();
        }
        this.responseModels.clear();
        this.responseModels.put(name, type);
    }

    public Class<?> getResponseModel(String name) {
        return this.getResponseModel(name, null);
    }

    public Class<?> getResponseModel(String name, Class<?> defaultType) {
        Class<?> model = defaultType;
        if (this.responseModels != null && this.responseModels.containsKey(name)) {
            model = this.responseModels.get(name);
        }
        return model;
    }

    public ServiceNowConfiguration copy() {
        try {
            return (ServiceNowConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

