/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TCPConnection
implements AutoCloseable {
    final Logger logger = LoggerFactory.getLogger(TCPConnection.class);
    ReentrantLock mu = new ReentrantLock();
    private SocketFactory factory = SocketFactory.getDefault();
    private SSLContext sslContext;
    Socket client = null;
    protected OutputStream writeStream = null;
    protected InputStream readStream = null;
    protected BufferedReader bisr = null;
    protected BufferedInputStream bis = null;
    protected BufferedOutputStream bos = null;
    protected InetSocketAddress addr = null;
    protected int timeout = 0;
    boolean tlsDebug = false;

    public void open(String host, int port, int timeoutMillis) throws IOException {
        this.logger.trace("TCPConnection.open({},{},{})", new Object[]{host, port, timeoutMillis});
        this.mu.lock();
        try {
            this.addr = new InetSocketAddress(host, port);
            this.client = this.factory.createSocket();
            this.client.connect(this.addr, this.timeout);
            this.open();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.mu.unlock();
        }
    }

    public void open() throws IOException {
        this.mu.lock();
        try {
            this.client.setTcpNoDelay(false);
            this.client.setReceiveBufferSize(65536);
            this.client.setSendBufferSize(65536);
            this.writeStream = this.client.getOutputStream();
            this.readStream = this.client.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.mu.unlock();
        }
    }

    protected void setConnectTimeout(int value) {
        this.timeout = value;
    }

    public boolean isSetup() {
        return this.client != null;
    }

    public void teardown() {
        this.mu.lock();
        try {
            if (this.client != null) {
                this.client.close();
            }
            this.client = null;
            this.writeStream = null;
            this.readStream = null;
            this.bisr = null;
            this.bis = null;
            this.bos = null;
        }
        catch (IOException iOException) {
        }
        finally {
            this.mu.unlock();
        }
    }

    public BufferedReader getBufferedReader() {
        return new BufferedReader(new InputStreamReader(this.bis));
    }

    public BufferedInputStream getBufferedInputStream(int size) {
        if (this.bis == null) {
            this.bis = new BufferedInputStream(this.readStream, size);
        }
        return this.bis;
    }

    public BufferedOutputStream getBufferedOutputStream(int size) {
        if (this.bos == null) {
            this.bos = new BufferedOutputStream(this.writeStream, size);
        }
        return this.bos;
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        return this.client.isConnected();
    }

    public boolean isDataAvailable() throws IOException {
        if (this.readStream == null) {
            return false;
        }
        return this.readStream.available() > 0;
    }

    protected void setSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }

    protected void makeTLS(SSLContext context) throws IOException {
        this.sslContext = context;
        this.setSocketFactory(this.sslContext.getSocketFactory());
        SSLSocketFactory sslSf = (SSLSocketFactory)this.factory;
        SSLSocket sslSocket = (SSLSocket)sslSf.createSocket(this.client, this.client.getInetAddress().getHostAddress(), this.client.getPort(), true);
        if (this.isTlsDebug()) {
            sslSocket.addHandshakeCompletedListener(new HandshakeListener());
        }
        this.logger.trace("Starting TLS handshake");
        sslSocket.startHandshake();
        this.logger.trace("TLS handshake complete");
        this.bisr = null;
        this.readStream = sslSocket.getInputStream();
        this.bis = null;
        this.writeStream = sslSocket.getOutputStream();
        this.bos = null;
    }

    protected void setSocket(Socket sock) {
        this.mu.lock();
        try {
            this.client = sock;
        }
        finally {
            this.mu.unlock();
        }
    }

    public boolean isTlsDebug() {
        return this.tlsDebug;
    }

    public void setTlsDebug(boolean tlsDebug) {
        this.tlsDebug = tlsDebug;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.teardown();
    }

    class HandshakeListener
    implements HandshakeCompletedListener {
        HandshakeListener() {
        }

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            SSLSession session = event.getSession();
            TCPConnection.this.logger.trace("Handshake Completed with peer {}", (Object)session.getPeerHost());
            TCPConnection.this.logger.trace("   cipher: {}", (Object)session.getCipherSuite());
            Certificate[] certs = null;
            try {
                certs = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException puv) {
                certs = null;
            }
            if (certs != null) {
                TCPConnection.this.logger.trace("   peer certificates:");
                for (int z = 0; z < certs.length; ++z) {
                    TCPConnection.this.logger.trace("      certs[{}]: {}", (Object)z, (Object)certs[z]);
                }
            } else {
                TCPConnection.this.logger.trace("No peer certificates presented");
            }
        }
    }
}

