/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;

public class ChildMemoryCircuitBreaker
implements CircuitBreaker {
    private final long memoryBytesLimit;
    private final BreakerSettings settings;
    private final double overheadConstant;
    private final AtomicLong used;
    private final AtomicLong trippedCount;
    private final ESLogger logger;
    private final HierarchyCircuitBreakerService parent;
    private final String name;

    public ChildMemoryCircuitBreaker(BreakerSettings settings, ESLogger logger, HierarchyCircuitBreakerService parent, String name) {
        this(settings, null, logger, parent, name);
    }

    public ChildMemoryCircuitBreaker(BreakerSettings settings, ChildMemoryCircuitBreaker oldBreaker, ESLogger logger, HierarchyCircuitBreakerService parent, String name) {
        this.name = name;
        this.settings = settings;
        this.memoryBytesLimit = settings.getLimit();
        this.overheadConstant = settings.getOverhead();
        if (oldBreaker == null) {
            this.used = new AtomicLong(0L);
            this.trippedCount = new AtomicLong(0L);
        } else {
            this.used = oldBreaker.used;
            this.trippedCount = oldBreaker.trippedCount;
        }
        this.logger = logger;
        if (logger.isTraceEnabled()) {
            logger.trace("creating ChildCircuitBreaker with settings {}", this.settings);
        }
        this.parent = parent;
    }

    @Override
    public void circuitBreak(String fieldName, long bytesNeeded) {
        this.trippedCount.incrementAndGet();
        String message = "[" + this.name + "] Data too large, data for [" + fieldName + "] would be larger than limit of [" + this.memoryBytesLimit + "/" + new ByteSizeValue(this.memoryBytesLimit) + "]";
        this.logger.debug(message, new Object[0]);
        throw new CircuitBreakingException(message, bytesNeeded, this.memoryBytesLimit);
    }

    @Override
    public double addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
        long newUsed;
        if (this.memoryBytesLimit == 0L) {
            this.circuitBreak(label, bytes);
        }
        if (this.memoryBytesLimit == -1L) {
            newUsed = this.used.addAndGet(bytes);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: [-1b]]", this.name, new ByteSizeValue(bytes), label, new ByteSizeValue(newUsed));
            }
        } else {
            long currentUsed;
            do {
                currentUsed = this.used.get();
                newUsed = currentUsed + bytes;
                long newUsedWithOverhead = (long)((double)newUsed * this.overheadConstant);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: {} [{}], estimate: {} [{}]]", this.name, new ByteSizeValue(bytes), label, new ByteSizeValue(newUsed), this.memoryBytesLimit, new ByteSizeValue(this.memoryBytesLimit), newUsedWithOverhead, new ByteSizeValue(newUsedWithOverhead));
                }
                if (this.memoryBytesLimit <= 0L || newUsedWithOverhead <= this.memoryBytesLimit) continue;
                this.logger.warn("[{}] New used memory {} [{}] for data of [{}] would be larger than configured breaker: {} [{}], breaking", this.name, newUsedWithOverhead, new ByteSizeValue(newUsedWithOverhead), label, this.memoryBytesLimit, new ByteSizeValue(this.memoryBytesLimit));
                this.circuitBreak(label, newUsedWithOverhead);
            } while (!this.used.compareAndSet(currentUsed, newUsed));
        }
        try {
            this.parent.checkParentLimit(label);
        }
        catch (CircuitBreakingException e) {
            this.addWithoutBreaking(-bytes);
            throw e;
        }
        return newUsed;
    }

    @Override
    public long addWithoutBreaking(long bytes) {
        long u = this.used.addAndGet(bytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] Adjusted breaker by [{}] bytes, now [{}]", this.name, bytes, u);
        }
        assert (u >= 0L) : "Used bytes: [" + u + "] must be >= 0";
        return u;
    }

    @Override
    public long getUsed() {
        return this.used.get();
    }

    @Override
    public long getLimit() {
        return this.memoryBytesLimit;
    }

    @Override
    public double getOverhead() {
        return this.overheadConstant;
    }

    @Override
    public long getTrippedCount() {
        return this.trippedCount.get();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

