/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalBucketMetricValue
extends InternalNumericMetricsAggregation.SingleValue {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("bucket_metric_value");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalBucketMetricValue readResult(StreamInput in) throws IOException {
            InternalBucketMetricValue result = new InternalBucketMetricValue();
            result.readFrom(in);
            return result;
        }
    };
    private double value;
    private String[] keys;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    protected InternalBucketMetricValue() {
    }

    public InternalBucketMetricValue(String name, String[] keys, double value, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.keys = keys;
        this.value = value;
        this.valueFormatter = formatter;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public double value() {
        return this.value;
    }

    public String[] keys() {
        return this.keys;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.value();
        }
        if (path.size() == 1 && "keys".equals(path.get(0))) {
            return this.keys();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.value = in.readDouble();
        this.keys = in.readStringArray();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDouble(this.value);
        out.writeStringArray(this.keys);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value);
        builder.field(InternalAggregation.CommonFields.VALUE, hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && !(this.valueFormatter instanceof ValueFormatter.Raw)) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.value));
        }
        builder.startArray("keys");
        for (String key : this.keys) {
            builder.value(key);
        }
        builder.endArray();
        return builder;
    }
}

