/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.camel.component.lucene.LuceneConstants;
import org.apache.camel.component.lucene.LuceneOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;

@UriParams
public class LuceneConfiguration {
    private URI uri;
    private String authority;
    private Version luceneVersion = LuceneConstants.LUCENE_VERSION;
    @UriPath
    @Metadata(required="true")
    private String host;
    @UriPath
    @Metadata(required="true")
    private LuceneOperation operation;
    @UriParam(name="srcDir")
    private File sourceDirectory;
    @UriParam(name="indexDir")
    private File indexDirectory;
    @UriParam
    private Analyzer analyzer;
    @UriParam
    private int maxHits;

    public LuceneConfiguration() {
    }

    public LuceneConfiguration(URI uri) throws Exception {
        this.uri = uri;
    }

    public void parseURI(URI uri, Map<String, Object> parameters, LuceneComponent component) throws Exception {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("lucene")) {
            throw new IllegalArgumentException("Unrecognized Lucene protocol: " + protocol + " for uri: " + uri);
        }
        this.setUri(uri);
        this.setAuthority(uri.getAuthority());
        if (!this.isValidAuthority()) {
            throw new URISyntaxException(uri.toASCIIString(), "Incorrect URI syntax and/or Operation specified for the Lucene endpoint.Please specify the syntax as \"lucene:[Endpoint Name]:[Operation]?[Query]\"");
        }
        this.setHost(this.retrieveTokenFromAuthority("hostname"));
        String op = this.retrieveTokenFromAuthority("operation");
        if (op != null) {
            op = op.toLowerCase();
        }
        this.setOperation(LuceneOperation.valueOf(op));
        this.sourceDirectory = (File)component.resolveAndRemoveReferenceParameter(parameters, "srcDir", File.class, null);
        this.indexDirectory = (File)component.resolveAndRemoveReferenceParameter(parameters, "indexDir", File.class, new File("file:///./indexDirectory"));
        this.analyzer = (Analyzer)component.resolveAndRemoveReferenceParameter(parameters, "analyzer", Analyzer.class, new StandardAnalyzer());
        this.setMaxHits((Integer)component.getAndRemoveParameter(parameters, "maxHits", Integer.class, 10));
    }

    private boolean isValidAuthority() throws URISyntaxException {
        return this.authority.contains(":") && this.authority.split(":")[0] != null && (this.authority.split(":")[1].equalsIgnoreCase("insert") || this.authority.split(":")[1].equalsIgnoreCase("query"));
    }

    private String retrieveTokenFromAuthority(String token) throws URISyntaxException {
        String retval = token.equalsIgnoreCase("hostname") ? this.uri.getAuthority().split(":")[0] : this.uri.getAuthority().split(":")[1];
        return retval;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public LuceneOperation getOperation() {
        return this.operation;
    }

    public void setOperation(LuceneOperation operation) {
        this.operation = operation;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(File indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public void setLuceneVersion(Version luceneVersion) {
        this.luceneVersion = luceneVersion;
    }

    public Version getLuceneVersion() {
        return this.luceneVersion;
    }
}

