/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnCompletionProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(OnCompletionProcessor.class);
    private final CamelContext camelContext;
    private String id;
    private final Processor processor;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final boolean onCompleteOnly;
    private final boolean onFailureOnly;
    private final Predicate onWhen;
    private final boolean useOriginalBody;
    private final boolean afterConsumer;

    public OnCompletionProcessor(CamelContext camelContext, Processor processor, ExecutorService executorService, boolean shutdownExecutorService, boolean onCompleteOnly, boolean onFailureOnly, Predicate onWhen, boolean useOriginalBody, boolean afterConsumer) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        this.camelContext = camelContext;
        this.processor = processor;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.onCompleteOnly = onCompleteOnly;
        this.onFailureOnly = onFailureOnly;
        this.onWhen = onWhen;
        this.useOriginalBody = useOriginalBody;
        this.afterConsumer = afterConsumer;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.processor != null) {
            if (this.afterConsumer) {
                exchange.getUnitOfWork().addSynchronization(new OnCompletionSynchronizationAfterConsumer());
            } else {
                exchange.getUnitOfWork().addSynchronization(new OnCompletionSynchronizationBeforeConsumer());
            }
        }
        callback.done(true);
        return true;
    }

    protected boolean isCreateCopy() {
        return this.executorService != null || this.afterConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doProcess(Processor processor, Exchange exchange) {
        Object stop = exchange.removeProperty("CamelRouteStop");
        Object failureHandled = exchange.removeProperty("CamelFailureHandled");
        Object errorhandlerHandled = exchange.removeProperty("CamelErrorHandlerHandled");
        Object rollbackOnly = exchange.removeProperty("CamelRollbackOnly");
        Object rollbackOnlyLast = exchange.removeProperty("CamelRollbackOnlyLast");
        Exception cause = exchange.getException();
        exchange.setException(null);
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            if (stop != null) {
                exchange.setProperty("CamelRouteStop", stop);
            }
            if (failureHandled != null) {
                exchange.setProperty("CamelFailureHandled", failureHandled);
            }
            if (errorhandlerHandled != null) {
                exchange.setProperty("CamelErrorHandlerHandled", errorhandlerHandled);
            }
            if (rollbackOnly != null) {
                exchange.setProperty("CamelRollbackOnly", rollbackOnly);
            }
            if (rollbackOnlyLast != null) {
                exchange.setProperty("CamelRollbackOnlyLast", rollbackOnlyLast);
            }
            if (cause != null) {
                exchange.setException(cause);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange answer;
        if (this.isCreateCopy()) {
            answer = ExchangeHelper.createCorrelatedCopy(exchange, false);
            if (answer.hasOut()) {
                answer.setIn(answer.getOut());
                answer.setOut(null);
            }
            answer.setPattern(ExchangePattern.InOnly);
        } else {
            answer = exchange;
        }
        if (this.useOriginalBody) {
            LOG.trace("Using the original IN message instead of current");
            Message original = ExchangeHelper.getOriginalInMessage(exchange);
            answer.setIn(original);
        }
        answer.setProperty("CamelOnCompletion", Boolean.TRUE);
        return answer;
    }

    public String toString() {
        return "OnCompletionProcessor[" + this.processor + "]";
    }

    @Override
    public String getTraceLabel() {
        return "onCompletion";
    }

    private final class OnCompletionSynchronizationBeforeConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private OnCompletionSynchronizationBeforeConsumer() {
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void onAfterRoute(Route route, Exchange exchange) {
            if (exchange.isFailed() && OnCompletionProcessor.this.onCompleteOnly) {
                return;
            }
            if (!exchange.isFailed() && OnCompletionProcessor.this.onFailureOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            } else {
                LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
            }
        }

        public String toString() {
            return "onAfterRoute";
        }
    }

    private final class OnCompletionSynchronizationAfterConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private OnCompletionSynchronizationAfterConsumer() {
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void onComplete(Exchange exchange) {
            if (OnCompletionProcessor.this.onFailureOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onComplete: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            } else {
                LOG.debug("Processing onComplete: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
            }
        }

        @Override
        public void onFailure(Exchange exchange) {
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            final Exception original = copy.getException();
            boolean originalFault = copy.hasOut() ? copy.getOut().isFault() : copy.getIn().isFault();
            copy.setException(null);
            if (copy.hasOut()) {
                copy.getOut().setFault(false);
            } else {
                copy.getIn().setFault(false);
            }
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onFailure: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        copy.setException(original);
                        return null;
                    }
                });
            } else {
                LOG.debug("Processing onFailure: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                copy.setException(original);
                if (copy.hasOut()) {
                    copy.getOut().setFault(originalFault);
                } else {
                    copy.getIn().setFault(originalFault);
                }
            }
        }

        public String toString() {
            if (!OnCompletionProcessor.this.onCompleteOnly && !OnCompletionProcessor.this.onFailureOnly) {
                return "onCompleteOrFailure";
            }
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return "onCompleteOnly";
            }
            return "onFailureOnly";
        }
    }
}

