/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.DefaultUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowRegistry;
import org.apache.camel.component.undertow.handlers.HttpCamelHandler;
import org.apache.camel.component.undertow.handlers.NotFoundHandler;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowComponent
extends UriEndpointComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowEndpoint.class);
    private UndertowHttpBinding undertowHttpBinding = new DefaultUndertowHttpBinding();
    private final Map<Integer, UndertowRegistry> serversRegistry = new HashMap<Integer, UndertowRegistry>();

    public UndertowComponent() {
        super(UndertowEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI uriHttpUriAddress = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, parameters);
        UndertowEndpoint endpoint = this.createEndpointInstance(endpointUri, this);
        endpoint.setUndertowHttpBinding(this.undertowHttpBinding);
        this.setProperties((Object)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpURI(httpUri);
        return endpoint;
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new UndertowEndpoint(endpointUri.toString(), component);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("undertow", true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        HashMap map = new HashMap();
        if ((config.getComponent() == null || config.getComponent().equals("undertow")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        String query = URISupport.createQueryString(map);
        String url = api ? "undertow:%s://%s:%s/%s?matchOnUriPrefix=true" : "undertow:%s://%s:%s/%s";
        url = String.format(url, scheme, host, port, path);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        UndertowEndpoint endpoint = (UndertowEndpoint)camelContext.getEndpoint(url, UndertowEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.serversRegistry.clear();
    }

    public void registerConsumer(UndertowConsumer consumer) {
        int port = consumer.getEndpoint().getHttpURI().getPort();
        if (this.serversRegistry.containsKey(port)) {
            UndertowRegistry undertowRegistry = this.serversRegistry.get(port);
            undertowRegistry.registerConsumer(consumer);
        } else {
            this.serversRegistry.put(port, new UndertowRegistry(consumer, port));
        }
    }

    public void unregisterConsumer(UndertowConsumer consumer) {
        int port = consumer.getEndpoint().getHttpURI().getPort();
        if (this.serversRegistry.containsKey(port)) {
            this.serversRegistry.get(port).unregisterConsumer(consumer);
        }
        if (this.serversRegistry.get(port).isEmpty()) {
            Undertow server = this.serversRegistry.get(port).getServer();
            if (server != null) {
                server.stop();
            }
            this.serversRegistry.remove(port);
        } else {
            this.startServer(consumer);
        }
    }

    public void startServer(UndertowConsumer consumer) {
        int port = consumer.getEndpoint().getHttpURI().getPort();
        LOG.info("Starting server on port: {}", (Object)port);
        UndertowRegistry undertowRegistry = this.serversRegistry.get(port);
        if (undertowRegistry.getServer() != null) {
            undertowRegistry.getServer().stop();
        }
        Undertow newServer = this.rebuildServer(undertowRegistry);
        newServer.start();
        undertowRegistry.setServer(newServer);
    }

    protected Undertow rebuildServer(UndertowRegistry registy) {
        Undertow.Builder result = Undertow.builder();
        result = registy.getSslContext() != null ? result.addHttpsListener(registy.getPort(), registy.getHost(), registy.getSslContext()) : result.addHttpListener(registy.getPort(), registy.getHost());
        PathHandler path = Handlers.path((HttpHandler)new NotFoundHandler());
        for (URI key : registy.getConsumersRegistry().keySet()) {
            UndertowConsumer consumer = registy.getConsumersRegistry().get(key);
            URI httpUri = consumer.getEndpoint().getHttpURI();
            HttpCamelHandler handler = new HttpCamelHandler(consumer);
            if (consumer.getEndpoint().getMatchOnUriPrefix().booleanValue()) {
                path.addPrefixPath(httpUri.getPath(), (HttpHandler)handler);
            } else {
                path.addExactPath(httpUri.getPath(), (HttpHandler)handler);
            }
            LOG.debug("Rebuild for path: {}", (Object)httpUri.getPath());
        }
        result = result.setHandler((HttpHandler)path);
        return result.build();
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }
}

