/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpServerExchange;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.jsse.SSLContextParameters;

@UriEndpoint(scheme="undertow", title="Undertow", syntax="undertow:httpURI", consumerClass=UndertowConsumer.class, label="http")
public class UndertowEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private UndertowComponent component;
    private SSLContext sslContext;
    @UriPath
    private URI httpURI;
    @UriParam
    private UndertowHttpBinding undertowHttpBinding;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam
    private SSLContextParameters sslContextParameters;
    @UriParam(label="consumer")
    private String httpMethodRestrict;
    @UriParam(label="consumer", defaultValue="true")
    private Boolean matchOnUriPrefix = true;
    @UriParam(label="producer")
    private Boolean throwExceptionOnFailure;
    @UriParam
    private Boolean transferException;

    public UndertowEndpoint(String uri, UndertowComponent component) throws URISyntaxException {
        super(uri, (Component)component);
        this.component = component;
    }

    public UndertowComponent getComponent() {
        return this.component;
    }

    public Producer createProducer() throws Exception {
        return new UndertowProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new UndertowConsumer(this, processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException("This component does not support polling consumer");
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Exchange createExchange(HttpServerExchange httpExchange) throws Exception {
        Exchange exchange = this.createExchange();
        Message in = this.getUndertowHttpBinding().toCamelMessage(httpExchange, exchange);
        exchange.setProperty("CamelCharsetName", (Object)httpExchange.getRequestCharset());
        in.setHeader("CamelHttpCharacterEncoding", (Object)httpExchange.getRequestCharset());
        exchange.setIn(in);
        return exchange;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public URI getHttpURI() {
        return this.httpURI;
    }

    public void setHttpURI(URI httpURI) {
        this.httpURI = httpURI;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public Boolean getMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(Boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.undertowHttpBinding.setHeaderFilterStrategy(headerFilterStrategy);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(Boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public Boolean getTransferException() {
        return this.transferException;
    }

    public void setTransferException(Boolean transferException) {
        this.transferException = transferException;
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.sslContextParameters != null) {
            this.sslContext = this.sslContextParameters.createSSLContext();
        }
    }
}

