/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowProducer.class);
    private UndertowEndpoint endpoint;

    public UndertowProducer(UndertowEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public UndertowEndpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            UndertowClient client = UndertowClient.getInstance();
            XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.EMPTY);
            IoFuture connect = client.connect(this.endpoint.getHttpURI(), worker, (Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 0x4000000), OptionMap.EMPTY);
            String url = UndertowHelper.createURL(exchange, this.getEndpoint());
            URI uri = UndertowHelper.createURI(exchange, url, this.getEndpoint());
            url = uri.toASCIIString();
            HttpString method = UndertowHelper.createMethod(exchange, this.endpoint, exchange.getIn().getBody() != null);
            ClientRequest request = new ClientRequest();
            request.setProtocol(Protocols.HTTP_1_1);
            request.setPath(url);
            request.setMethod(method);
            Object body = this.getRequestBody(request, exchange);
            TypeConverter tc = this.endpoint.getCamelContext().getTypeConverter();
            ByteBuffer bodyAsByte = (ByteBuffer)tc.tryConvertTo(ByteBuffer.class, body);
            if (body != null) {
                request.getRequestHeaders().put(Headers.CONTENT_LENGTH, (long)bodyAsByte.array().length);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing http {} method: {}", (Object)method, (Object)url);
            }
            ((ClientConnection)connect.get()).sendRequest(request, (ClientCallback)new UndertowProducerCallback(bodyAsByte, exchange, callback));
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    private Object getRequestBody(ClientRequest request, Exchange camelExchange) {
        return this.endpoint.getUndertowHttpBinding().toHttpRequest(request, camelExchange.getIn());
    }

    private class UndertowProducerCallback
    implements ClientCallback<ClientExchange> {
        private final ByteBuffer body;
        private final Exchange camelExchange;
        private final AsyncCallback callback;

        public UndertowProducerCallback(ByteBuffer body, Exchange camelExchange, AsyncCallback callback) {
            this.body = body;
            this.camelExchange = camelExchange;
            this.callback = callback;
        }

        public void completed(ClientExchange clientExchange) {
            clientExchange.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(ClientExchange clientExchange) {
                    LOG.trace("completed: {}", (Object)clientExchange);
                    try {
                        Message message = UndertowProducer.this.endpoint.getUndertowHttpBinding().toCamelMessage(clientExchange, UndertowProducerCallback.this.camelExchange);
                        if (ExchangeHelper.isOutCapable((Exchange)UndertowProducerCallback.this.camelExchange)) {
                            UndertowProducerCallback.this.camelExchange.setOut(message);
                        } else {
                            UndertowProducerCallback.this.camelExchange.setIn(message);
                        }
                    }
                    catch (Exception e) {
                        UndertowProducerCallback.this.camelExchange.setException((Throwable)e);
                    }
                    finally {
                        UndertowProducerCallback.this.callback.done(false);
                    }
                }

                public void failed(IOException e) {
                    LOG.trace("failed: {}", (Throwable)e);
                    UndertowProducerCallback.this.camelExchange.setException((Throwable)e);
                    UndertowProducerCallback.this.callback.done(false);
                }
            });
            try {
                if (this.body != null) {
                    clientExchange.getRequestChannel().write(this.body);
                }
            }
            catch (IOException e) {
                this.camelExchange.setException((Throwable)e);
                this.callback.done(false);
            }
        }

        public void failed(IOException e) {
            LOG.trace("failed: {}", (Throwable)e);
            this.camelExchange.setException((Throwable)e);
            this.callback.done(false);
        }
    }
}

