/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.operation.plain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.operation.OperationRouting;
import org.elasticsearch.cluster.routing.operation.hash.HashFunction;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.cluster.routing.operation.plain.Preference;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexMissingException;

public class PlainOperationRouting
extends AbstractComponent
implements OperationRouting {
    private final HashFunction hashFunction;
    private final boolean useType;
    private final AwarenessAllocationDecider awarenessAllocationDecider;
    private static final Map<String, Set<String>> EMPTY_ROUTING = Collections.emptyMap();

    @Inject
    public PlainOperationRouting(Settings indexSettings, HashFunction hashFunction, AwarenessAllocationDecider awarenessAllocationDecider) {
        super(indexSettings);
        this.hashFunction = hashFunction;
        this.useType = indexSettings.getAsBoolean("cluster.routing.operation.use_type", (Boolean)false);
        this.awarenessAllocationDecider = awarenessAllocationDecider;
    }

    @Override
    public ShardIterator indexShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index, type, id, routing).shardsIt();
    }

    @Override
    public ShardIterator deleteShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index, type, id, routing).shardsIt();
    }

    @Override
    public ShardIterator getShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing, @Nullable String preference) throws IndexMissingException, IndexShardMissingException {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, type, id, routing), clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
    }

    @Override
    public ShardIterator getShards(ClusterState clusterState, String index, int shardId, @Nullable String preference) throws IndexMissingException, IndexShardMissingException {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, shardId), clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
    }

    @Override
    public GroupShardsIterator broadcastDeleteShards(ClusterState clusterState, String index) throws IndexMissingException {
        return this.indexRoutingTable(clusterState, index).groupByShardsIt();
    }

    @Override
    public GroupShardsIterator deleteByQueryShards(ClusterState clusterState, String index, @Nullable Set<String> routing) throws IndexMissingException {
        if (routing == null || routing.isEmpty()) {
            return this.indexRoutingTable(clusterState, index).groupByShardsIt();
        }
        HashSet<ShardIterator> set = new HashSet<ShardIterator>();
        IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
        for (String r : routing) {
            int shardId = this.shardId(clusterState, index, null, null, r);
            IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
            if (indexShard == null) {
                throw new IndexShardMissingException(new ShardId(index, shardId));
            }
            set.add(indexShard.shardsRandomIt());
        }
        return new GroupShardsIterator(Lists.newArrayList(set));
    }

    @Override
    public int searchShardsCount(ClusterState clusterState, String[] indices, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) throws IndexMissingException {
        Set<IndexShardRoutingTable> shards = this.computeTargetedShards(clusterState, concreteIndices, routing);
        return shards.size();
    }

    @Override
    public GroupShardsIterator searchShards(ClusterState clusterState, String[] indices, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) throws IndexMissingException {
        Set<IndexShardRoutingTable> shards = this.computeTargetedShards(clusterState, concreteIndices, routing);
        HashSet<ShardIterator> set = new HashSet<ShardIterator>(shards.size());
        for (IndexShardRoutingTable shard : shards) {
            ShardIterator iterator = this.preferenceActiveShardIterator(shard, clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
            if (iterator == null) continue;
            set.add(iterator);
        }
        return new GroupShardsIterator(Lists.newArrayList(set));
    }

    private Set<IndexShardRoutingTable> computeTargetedShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) throws IndexMissingException {
        routing = routing == null ? EMPTY_ROUTING : routing;
        HashSet<IndexShardRoutingTable> set = new HashSet<IndexShardRoutingTable>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            Set<String> effectiveRouting = routing.get(index);
            if (effectiveRouting != null) {
                for (String r : effectiveRouting) {
                    int shardId = this.shardId(clusterState, index, null, null, r);
                    IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
                    if (indexShard == null) {
                        throw new IndexShardMissingException(new ShardId(index, shardId));
                    }
                    set.add(indexShard);
                }
                continue;
            }
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(indexShard);
            }
        }
        return set;
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference) {
        if (preference == null || preference.isEmpty()) {
            String[] awarenessAttributes = this.awarenessAllocationDecider.awarenessAttributes();
            if (awarenessAttributes.length == 0) {
                return indexShard.activeInitializingShardsRandomIt();
            }
            return indexShard.preferAttributesActiveInitializingShardsIt(awarenessAttributes, nodes);
        }
        if (preference.charAt(0) == '_') {
            Preference preferenceType = Preference.parse(preference);
            if (preferenceType == Preference.SHARDS) {
                int index = preference.indexOf(59);
                String shards = index == -1 ? preference.substring(Preference.SHARDS.type().length() + 1) : preference.substring(Preference.SHARDS.type().length() + 1, index);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id : ids) {
                    if (Integer.parseInt(id) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index == -1 || index == preference.length() - 1) {
                    String[] awarenessAttributes = this.awarenessAllocationDecider.awarenessAttributes();
                    if (awarenessAttributes.length == 0) {
                        return indexShard.activeInitializingShardsRandomIt();
                    }
                    return indexShard.preferAttributesActiveInitializingShardsIt(awarenessAttributes, nodes);
                }
                preference = preference.substring(index + 1);
            }
            preferenceType = Preference.parse(preference);
            switch (preferenceType) {
                case PREFER_NODE: {
                    return indexShard.preferNodeActiveInitializingShardsIt(preference.substring(Preference.PREFER_NODE.type().length() + 1));
                }
                case LOCAL: {
                    return indexShard.preferNodeActiveInitializingShardsIt(localNodeId);
                }
                case PRIMARY: {
                    return indexShard.primaryActiveInitializingShardIt();
                }
                case PRIMARY_FIRST: {
                    return indexShard.primaryFirstActiveInitializingShardsIt();
                }
                case ONLY_LOCAL: {
                    return indexShard.onlyNodeActiveInitializingShardsIt(localNodeId);
                }
                case ONLY_NODE: {
                    String nodeId = preference.substring(Preference.ONLY_NODE.type().length() + 1);
                    this.ensureNodeIdExists(nodes, nodeId);
                    return indexShard.onlyNodeActiveInitializingShardsIt(nodeId);
                }
                case ONLY_NODES: {
                    String nodeAttribute = preference.substring(Preference.ONLY_NODES.type().length() + 1);
                    return indexShard.onlyNodeSelectorActiveInitializingShardsIt(nodeAttribute, nodes);
                }
            }
            throw new ElasticsearchIllegalArgumentException("unknown preference [" + (Object)((Object)preferenceType) + "]");
        }
        String[] awarenessAttributes = this.awarenessAllocationDecider.awarenessAttributes();
        if (awarenessAttributes.length == 0) {
            return indexShard.activeInitializingShardsIt(DjbHashFunction.DJB_HASH(preference));
        }
        return indexShard.preferAttributesActiveInitializingShardsIt(awarenessAttributes, nodes, DjbHashFunction.DJB_HASH(preference));
    }

    public IndexMetaData indexMetaData(ClusterState clusterState, String index) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index);
        if (indexMetaData == null) {
            throw new IndexMissingException(new Index(index));
        }
        return indexMetaData;
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexMissingException(new Index(index));
        }
        return indexRouting;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, String type, String id, String routing) {
        int shardId = this.shardId(clusterState, index, type, id, routing);
        return this.shards(clusterState, index, shardId);
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, int shardId) {
        IndexShardRoutingTable indexShard = this.indexRoutingTable(clusterState, index).shard(shardId);
        if (indexShard == null) {
            throw new IndexShardMissingException(new ShardId(index, shardId));
        }
        return indexShard;
    }

    private int shardId(ClusterState clusterState, String index, String type, @Nullable String id, @Nullable String routing) {
        if (routing == null) {
            if (!this.useType) {
                return Math.abs(this.hash(id) % this.indexMetaData(clusterState, index).numberOfShards());
            }
            return Math.abs(this.hash(type, id) % this.indexMetaData(clusterState, index).numberOfShards());
        }
        return Math.abs(this.hash(routing) % this.indexMetaData(clusterState, index).numberOfShards());
    }

    protected int hash(String routing) {
        return this.hashFunction.hash(routing);
    }

    protected int hash(String type, String id) {
        if (type == null || "_all".equals(type)) {
            throw new ElasticsearchIllegalArgumentException("Can't route an operation with no type and having type part of the routing (for backward comp)");
        }
        return this.hashFunction.hash(type, id);
    }

    private void ensureNodeIdExists(DiscoveryNodes nodes, String nodeId) {
        if (!nodes.dataNodes().keys().contains(nodeId)) {
            throw new ElasticsearchIllegalArgumentException("No data node with id[" + nodeId + "] found");
        }
    }
}

