/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.none;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.RecoveryState;

public class NoneIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final IndexShard indexShard;

    @Inject
    public NoneIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.indexShard = indexShard;
    }

    public String toString() {
        return "_none_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(boolean indexShouldExists, RecoveryState recoveryState) throws IndexShardGatewayRecoveryException {
        this.indexShard.prepareForIndexRecovery();
        this.indexShard.store().incRef();
        try {
            this.logger.debug("cleaning shard content before creation", new Object[0]);
            Lucene.cleanLuceneIndex(this.indexShard.store().directory());
        }
        catch (IOException e) {
            this.logger.warn("failed to clean store before starting shard", e, new Object[0]);
        }
        finally {
            this.indexShard.store().decRef();
        }
        recoveryState.getTranslog().totalOperations(0);
        recoveryState.getTranslog().totalOperationsOnStart(0);
        this.indexShard.prepareForTranslogRecovery();
        this.indexShard.finalizeRecovery();
        this.indexShard.postRecovery("post recovery from gateway");
    }

    @Override
    public String type() {
        return "none";
    }

    @Override
    public void close() {
    }
}

