/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.RafReference;

public class FsChannelSnapshot
implements Translog.Snapshot {
    private final long id;
    private final int totalOperations;
    private final RafReference raf;
    private final FileChannel channel;
    private final long length;
    private Translog.Operation lastOperationRead = null;
    private long position = 0L;
    private ByteBuffer cacheBuffer;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public FsChannelSnapshot(long id, RafReference raf, long length, int totalOperations) throws FileNotFoundException {
        this.id = id;
        this.raf = raf;
        this.channel = raf.raf().getChannel();
        this.length = length;
        this.totalOperations = totalOperations;
    }

    @Override
    public long translogId() {
        return this.id;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int estimatedTotalOperations() {
        return this.totalOperations;
    }

    @Override
    public long lengthInBytes() {
        return this.length - this.position;
    }

    @Override
    public Translog.Operation next() {
        try {
            if (this.position >= this.length) {
                return null;
            }
            if (this.cacheBuffer == null) {
                this.cacheBuffer = ByteBuffer.allocate(1024);
            }
            this.cacheBuffer.limit(4);
            int bytesRead = Channels.readFromFileChannel(this.channel, this.position, this.cacheBuffer);
            if (bytesRead < 0) {
                throw new EOFException("read past EOF. pos [" + this.position + "] length: [" + this.cacheBuffer.limit() + "] end: [" + this.channel.size() + "]");
            }
            assert (bytesRead == 4);
            this.cacheBuffer.flip();
            int opSize = this.cacheBuffer.getInt() + 4;
            if (this.position + (long)opSize > this.length) {
                throw new EOFException("opSize of [" + opSize + "] pointed beyond EOF. position [" + this.position + "] length [" + this.length + "]");
            }
            if (this.cacheBuffer.capacity() < opSize) {
                this.cacheBuffer = ByteBuffer.allocate(opSize);
            }
            this.cacheBuffer.clear();
            this.cacheBuffer.limit(opSize);
            bytesRead = Channels.readFromFileChannel(this.channel, this.position, this.cacheBuffer);
            if (bytesRead < 0) {
                throw new EOFException("tried to read past EOF. opSize [" + opSize + "] position [" + this.position + "] length [" + this.length + "]");
            }
            this.cacheBuffer.flip();
            this.position += (long)opSize;
            BytesArray bytesArray = new BytesArray(this.cacheBuffer.array(), 0, opSize);
            return TranslogStreams.readTranslogOperation(new BytesStreamInput(bytesArray.copyBytesArray()));
        }
        catch (IOException e) {
            throw new ElasticsearchException("unexpected exception reading from translog snapshot of " + this.raf.file(), e);
        }
    }

    @Override
    public void seekTo(long position) {
        this.position = position;
    }

    @Override
    public void close() throws ElasticsearchException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.raf.decreaseRefCount(false);
    }
}

