/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.utils;

import org.wildfly.extras.patch.PatchException;

public final class PatchAssertion {
    private PatchAssertion() {
    }

    public static <T> T assertNull(T value, String message) {
        if (value != null) {
            throw new PatchException(message);
        }
        return value;
    }

    public static <T> T assertNotNull(T value, String message) {
        if (value == null) {
            throw new PatchException(message);
        }
        return value;
    }

    public static Boolean assertTrue(Boolean value, String message) {
        if (!Boolean.valueOf(value).booleanValue()) {
            throw new PatchException(message);
        }
        return value;
    }

    public static Boolean assertFalse(Boolean value, String message) {
        if (Boolean.valueOf(value).booleanValue()) {
            throw new PatchException(message);
        }
        return value;
    }

    public static <T> T assertEquals(T exp, T was, String message) {
        PatchAssertion.assertNotNull(exp, message);
        PatchAssertion.assertNotNull(was, message);
        PatchAssertion.assertTrue(exp.equals(was), message);
        return was;
    }

    public static <T> T assertSame(T exp, T was, String message) {
        PatchAssertion.assertNotNull(exp, message);
        PatchAssertion.assertNotNull(was, message);
        PatchAssertion.assertTrue(exp == was, message);
        return was;
    }
}

