/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.writer.AbstractWriter;
import net.sf.flatpack.writer.WriterOptions;

public class DelimiterWriter
extends AbstractWriter {
    private final char delimiter;
    private final char qualifier;
    private List<String> columnTitles = null;
    private boolean columnTitlesWritten = false;

    protected DelimiterWriter(Map columnMapping, Writer output, char delimiter, char qualifier, WriterOptions options) throws IOException {
        super(output);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
        this.columnTitles = new ArrayList<String>();
        List columns = (List)columnMapping.get("detail");
        for (ColumnMetaData cmd : columns) {
            this.columnTitles.add(cmd.getColName());
        }
        if (options.isAutoPrintHeader()) {
            this.printHeader();
        }
    }

    protected void writeWithDelimiter(Object value) throws IOException {
        this.write(value);
        this.write(this.delimiter);
    }

    protected void write(Object value) throws IOException {
        boolean needsQuoting;
        String stringValue = "";
        if (value != null) {
            BigDecimal bd;
            stringValue = value instanceof BigDecimal ? ((bd = (BigDecimal)value).signum() == 0 ? "0" : bd.toPlainString()) : value.toString();
        }
        boolean bl = needsQuoting = stringValue.indexOf(this.delimiter) != -1 || this.qualifier != '\u0000' && stringValue.indexOf(this.qualifier) != -1 || stringValue.split("\r\n|\r|\n").length > 1;
        if (needsQuoting) {
            super.write(this.qualifier);
        }
        super.write(stringValue);
        if (needsQuoting) {
            super.write(this.qualifier);
        }
    }

    protected void addColumnTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("column title may not be null");
        }
        this.columnTitles.add(string);
    }

    protected void writeColumnTitles() throws IOException {
        Iterator<String> titleIter = this.columnTitles.iterator();
        while (titleIter.hasNext()) {
            String title = titleIter.next();
            if (titleIter.hasNext()) {
                this.writeWithDelimiter(title);
                continue;
            }
            this.write(title);
        }
    }

    protected void writeRow() throws IOException {
        Iterator<String> titlesIter = this.columnTitles.iterator();
        while (titlesIter.hasNext()) {
            String columnTitle = titlesIter.next();
            if (this.getRowMap() == null) continue;
            if (titlesIter.hasNext()) {
                this.writeWithDelimiter(this.getRowMap().get(columnTitle));
                continue;
            }
            this.write(this.getRowMap().get(columnTitle));
        }
    }

    public final void nextRecord() throws IOException {
        this.writeRow();
        super.nextRecord();
    }

    public void printFooter() throws IOException {
    }

    public void printHeader() throws IOException {
        if (!this.columnTitlesWritten) {
            this.writeColumnTitles();
            this.columnTitlesWritten = true;
            super.nextRecord();
        }
    }

    protected boolean validateColumnTitle(String columnTitle) {
        return this.columnTitles.contains(columnTitle);
    }
}

