/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.xcontent.XContentType;

public interface XContentParser
extends Releasable {
    public XContentType contentType();

    public Token nextToken() throws IOException;

    public void skipChildren() throws IOException;

    public Token currentToken();

    public String currentName() throws IOException;

    public Map<String, Object> map() throws IOException;

    public Map<String, Object> mapOrdered() throws IOException;

    public Map<String, Object> mapAndClose() throws IOException;

    public Map<String, Object> mapOrderedAndClose() throws IOException;

    public String text() throws IOException;

    public String textOrNull() throws IOException;

    public BytesRef utf8BytesOrNull() throws IOException;

    public BytesRef utf8Bytes() throws IOException;

    @Deprecated
    public BytesRef bytesOrNull() throws IOException;

    @Deprecated
    public BytesRef bytes() throws IOException;

    public Object objectText() throws IOException;

    public Object objectBytes() throws IOException;

    public boolean hasTextCharacters();

    public char[] textCharacters() throws IOException;

    public int textLength() throws IOException;

    public int textOffset() throws IOException;

    public Number numberValue() throws IOException;

    public NumberType numberType() throws IOException;

    public boolean estimatedNumberType();

    public short shortValue(boolean var1) throws IOException;

    public int intValue(boolean var1) throws IOException;

    public long longValue(boolean var1) throws IOException;

    public float floatValue(boolean var1) throws IOException;

    public double doubleValue(boolean var1) throws IOException;

    public short shortValue() throws IOException;

    public int intValue() throws IOException;

    public long longValue() throws IOException;

    public float floatValue() throws IOException;

    public double doubleValue() throws IOException;

    public boolean isBooleanValue() throws IOException;

    public boolean booleanValue() throws IOException;

    public byte[] binaryValue() throws IOException;

    public boolean isClosed();

    public static enum NumberType {
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }

    public static enum Token {
        START_OBJECT{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        END_OBJECT{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        START_ARRAY{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        END_ARRAY{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        FIELD_NAME{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        VALUE_STRING{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_NUMBER{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_BOOLEAN{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_EMBEDDED_OBJECT{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_NULL{

            @Override
            public boolean isValue() {
                return false;
            }
        };


        public abstract boolean isValue();
    }
}

