/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.csv;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyAbstractDataFormat;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyCsvFactory;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyCsvDataFormat
extends BindyAbstractDataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(BindyCsvDataFormat.class);

    public BindyCsvDataFormat() {
    }

    public BindyCsvDataFormat(Class<?> type) {
        super(type);
    }

    public String getDataFormatName() {
        return "bindy-csv";
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        BindyCsvFactory factory = (BindyCsvFactory)this.getFactory();
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        byte[] bytesCRLF = ConverterUtils.getByteReturn(factory.getCarriageReturn());
        if (factory.getGenerateHeaderColumnNames()) {
            String result = factory.generateHeader();
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
        ArrayList<Map> models = new ArrayList<Map>();
        Iterator it = ObjectHelper.createIterator((Object)body);
        while (it.hasNext()) {
            Object model = it.next();
            if (model instanceof Map) {
                models.add((Map)model);
                continue;
            }
            String name = model.getClass().getName();
            HashMap<String, Object> row = new HashMap<String, Object>(1);
            row.put(name, model);
            for (Field field : model.getClass().getDeclaredFields()) {
                Link linkField = field.getAnnotation(Link.class);
                if (linkField == null) continue;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                row.put(field.getType().getName(), field.get(model));
                field.setAccessible(accessible);
            }
            models.add(row);
        }
        for (Map model : models) {
            String result = factory.unbind(model);
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        BindyCsvFactory factory = (BindyCsvFactory)this.getFactory();
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        InputStreamReader in = new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange));
        Scanner scanner = new Scanner(in);
        String separator = factory.getSeparator();
        String quote = factory.getQuote();
        ObjectHelper.notNull((Object)separator, (String)"The separator has not been defined in the annotation @CsvRecord or not instantiated during initModel.");
        int count = 0;
        try {
            if (factory.getSkipFirstLine() && scanner.hasNextLine()) {
                scanner.nextLine();
            }
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (ObjectHelper.isEmpty((Object)line)) continue;
                ++count;
                Map<String, Object> model = factory.factory();
                String[] tokens = line.split(separator, -1);
                List<String> result = Arrays.asList(tokens);
                if ((result = this.unquoteTokens(result, separator, quote)).size() == 0 || result.isEmpty()) {
                    throw new IllegalArgumentException("No records have been defined in the CSV");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Size of the record splitted : {}", (Object)result.size());
                }
                if (factory.getAutospanLine()) {
                    result = BindyCsvDataFormat.autospanLine(result, factory.getMaxpos(), separator);
                }
                factory.bind(result, model, count);
                factory.link(model);
                models.add(model);
                LOG.debug("Graph of objects created: {}", model);
            }
            if (models.size() == 0) {
                throw new IllegalArgumentException("No records have been defined in the CSV");
            }
            Object object = this.extractUnmarshalResult(models);
            return object;
        }
        finally {
            scanner.close();
            IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
        }
    }

    private static List<String> autospanLine(List<String> result, int maxpos, String separator) {
        if (result.size() <= maxpos) {
            return result;
        }
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder lastRecord = new StringBuilder();
        Iterator<String> it = result.iterator();
        for (int counter = 0; counter < maxpos - 1; ++counter) {
            answer.add(it.next());
        }
        while (it.hasNext()) {
            lastRecord.append(it.next());
            if (!it.hasNext()) continue;
            lastRecord.append(separator);
        }
        answer.add(lastRecord.toString());
        return answer;
    }

    private List<String> unquoteTokens(List<String> result, String separator, String quote) {
        StringBuilder current = new StringBuilder();
        ArrayList<String> answer = new ArrayList<String>();
        for (String s : result) {
            boolean currentInProgress;
            boolean startQuote = false;
            boolean endQuote = false;
            if (s.startsWith(quote)) {
                s = s.substring(1);
                startQuote = true;
            }
            if (s.endsWith(quote)) {
                s = s.substring(0, s.length() - 1);
                endQuote = true;
            }
            boolean bl = currentInProgress = current.length() > 0;
            if (currentInProgress && startQuote && s.isEmpty()) {
                current.append(separator);
                answer.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (currentInProgress || startQuote) {
                if (currentInProgress) {
                    current.append(separator);
                }
                current.append(s);
            }
            boolean bl2 = currentInProgress = current.length() > 0;
            if (endQuote) {
                answer.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (currentInProgress) continue;
            answer.add(s);
        }
        if (current.length() > 0) {
            answer.add(current.toString());
            current.setLength(0);
        }
        return answer;
    }

    @Override
    protected BindyAbstractFactory createModelFactory() throws Exception {
        return new BindyCsvFactory(this.getClassType());
    }
}

