/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.component;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class AbstractComponent {
    protected final ESLogger logger;
    protected final Settings settings;
    protected final Settings componentSettings;

    public AbstractComponent(Settings settings) {
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
        this.settings = settings;
        this.componentSettings = settings.getComponentSettings(this.getClass());
    }

    public AbstractComponent(Settings settings, String prefixSettings) {
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
        this.settings = settings;
        this.componentSettings = settings.getComponentSettings(prefixSettings, this.getClass());
    }

    public AbstractComponent(Settings settings, Class customClass) {
        this.logger = Loggers.getLogger(customClass, settings, new String[0]);
        this.settings = settings;
        this.componentSettings = settings.getComponentSettings(customClass);
    }

    public AbstractComponent(Settings settings, String prefixSettings, Class customClass) {
        this.logger = Loggers.getLogger(customClass, settings, new String[0]);
        this.settings = settings;
        this.componentSettings = settings.getComponentSettings(prefixSettings, customClass);
    }

    public AbstractComponent(Settings settings, Class loggerClass, Class componentClass) {
        this.logger = Loggers.getLogger(loggerClass, settings, new String[0]);
        this.settings = settings;
        this.componentSettings = settings.getComponentSettings(componentClass);
    }

    public AbstractComponent(Settings settings, String prefixSettings, Class loggerClass, Class componentClass) {
        this.logger = Loggers.getLogger(loggerClass, settings, new String[0]);
        this.settings = settings;
        this.componentSettings = settings.getComponentSettings(prefixSettings, componentClass);
    }

    public String nodeName() {
        return this.settings.get("name", "");
    }
}

