/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.index.similarity.PreBuiltSimilarityProvider;

public class Similarities {
    private static final ImmutableMap<String, PreBuiltSimilarityProvider.Factory> PRE_BUILT_SIMILARITIES;

    private Similarities() {
    }

    public static ImmutableCollection<PreBuiltSimilarityProvider.Factory> listFactories() {
        return PRE_BUILT_SIMILARITIES.values();
    }

    static {
        MapBuilder<String, PreBuiltSimilarityProvider.Factory> similarities = MapBuilder.newMapBuilder();
        similarities.put("default", new PreBuiltSimilarityProvider.Factory("default", (Similarity)new DefaultSimilarity()));
        similarities.put("BM25", new PreBuiltSimilarityProvider.Factory("BM25", (Similarity)new BM25Similarity()));
        PRE_BUILT_SIMILARITIES = similarities.immutableMap();
    }
}

