/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.collect.ArrayListMultimap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;

public abstract class InternalTerms
extends InternalAggregation
implements Terms,
ToXContent,
Streamable {
    protected static final String DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME = "doc_count_error_upper_bound";
    protected static final String SUM_OF_OTHER_DOC_COUNTS = "sum_other_doc_count";
    protected Terms.Order order;
    protected int requiredSize;
    protected int shardSize;
    protected long minDocCount;
    protected List<Bucket> buckets;
    protected Map<String, Bucket> bucketMap;
    protected long docCountError;
    protected boolean showTermDocCountError;
    protected long otherDocCount;

    protected InternalTerms() {
    }

    protected InternalTerms(String name, Terms.Order order, int requiredSize, int shardSize, long minDocCount, List<Bucket> buckets, boolean showTermDocCountError, long docCountError, long otherDocCount) {
        super(name);
        this.order = order;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.minDocCount = minDocCount;
        this.buckets = buckets;
        this.showTermDocCountError = showTermDocCountError;
        this.docCountError = docCountError;
        this.otherDocCount = otherDocCount;
    }

    @Override
    public List<Terms.Bucket> getBuckets() {
        List<Terms.Bucket> o = this.buckets;
        return o;
    }

    @Override
    public Terms.Bucket getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newHashMapWithExpectedSize(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(term);
    }

    @Override
    public long getDocCountError() {
        return this.docCountError;
    }

    @Override
    public long getSumOfOtherDocCounts() {
        return this.otherDocCount;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        ArrayListMultimap<Object, Bucket> buckets = ArrayListMultimap.create();
        long sumDocCountError = 0L;
        long otherDocCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            otherDocCount += terms.getSumOfOtherDocCounts();
            long thisAggDocCountError = terms.buckets.size() < this.shardSize || this.order == InternalOrder.TERM_ASC || this.order == InternalOrder.TERM_DESC ? 0L : (InternalOrder.isCountDesc(this.order) ? terms.buckets.get((int)(terms.buckets.size() - 1)).docCount : -1L);
            if (sumDocCountError != -1L) {
                sumDocCountError = thisAggDocCountError == -1L ? -1L : (sumDocCountError += thisAggDocCountError);
            }
            terms.docCountError = thisAggDocCountError;
            for (Bucket bucket : terms.buckets) {
                bucket.docCountError = thisAggDocCountError;
                buckets.put(bucket.getKeyAsObject(), bucket);
            }
        }
        int size = Math.min(this.requiredSize, buckets.size());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(null));
        for (Collection l : buckets.asMap().values()) {
            Terms.Bucket removed;
            List sameTermBuckets = (List)l;
            Bucket b = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext);
            if (b.docCountError != -1L) {
                b.docCountError = sumDocCountError == -1L ? -1L : sumDocCountError - b.docCountError;
            }
            if (b.docCount < this.minDocCount || (removed = (Terms.Bucket)ordered.insertWithOverflow(b)) == null) continue;
            otherDocCount += removed.getDocCount();
        }
        Bucket[] list = new Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            list[i] = (Bucket)ordered.pop();
        }
        long docCountError = sumDocCountError == -1L ? -1L : (aggregations.size() == 1 ? 0L : sumDocCountError);
        return this.newAggregation(this.name, Arrays.asList(list), this.showTermDocCountError, docCountError, otherDocCount);
    }

    protected abstract InternalTerms newAggregation(String var1, List<Bucket> var2, boolean var3, long var4, long var6);

    public static abstract class Bucket
    extends Terms.Bucket {
        long bucketOrd;
        protected long docCount;
        protected long docCountError;
        protected InternalAggregations aggregations;
        protected boolean showDocCountError;

        protected Bucket(long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError) {
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.showDocCountError = showDocCountError;
            this.docCountError = docCountError;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public long getDocCountError() {
            if (!this.showDocCountError) {
                throw new ElasticsearchIllegalStateException("show_terms_doc_count_error is false");
            }
            return this.docCountError;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        abstract Object getKeyAsObject();

        abstract Bucket newBucket(long var1, InternalAggregations var3, long var4);

        public Bucket reduce(List<? extends Bucket> buckets, InternalAggregation.ReduceContext context) {
            long docCount = 0L;
            long docCountError = 0L;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                if (docCountError != -1L) {
                    docCountError = bucket.docCountError == -1L ? -1L : (docCountError += bucket.docCountError);
                }
                aggregationsList.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return this.newBucket(docCount, aggs, docCountError);
        }
    }
}

