/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanConsumerHandler;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.apache.camel.component.infinispan.InfinispanProducer;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.embedded.InfinispanConsumerEmbeddedHandler;
import org.apache.camel.component.infinispan.remote.InfinispanConsumerRemoteHandler;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteOperation;
import org.apache.camel.impl.DefaultConsumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanConsumer
extends DefaultConsumer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanProducer.class);
    private final InfinispanConfiguration configuration;
    private InfinispanEventListener listener;
    private InfinispanConsumerHandler consumerHandler;
    private BasicCache<Object, Object> cache;
    private ContinuousQuery<Object, Object> continuousQuery;

    public InfinispanConsumer(InfinispanEndpoint endpoint, Processor processor, InfinispanConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.configuration = configuration;
    }

    public void processEvent(String eventType, boolean isPre, String cacheName, Object key) {
        this.processEvent(eventType, isPre, cacheName, key, null);
    }

    public void processEvent(String eventType, boolean isPre, String cacheName, Object key, Object eventData) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getOut().setHeader("CamelInfinispanEventType", (Object)eventType);
        exchange.getOut().setHeader("CamelInfinispanIsPre", (Object)isPre);
        exchange.getOut().setHeader("CamelInfinispanCacheName", (Object)cacheName);
        exchange.getOut().setHeader("CamelInfinispanKey", key);
        if (eventData != null) {
            exchange.getOut().setHeader("CamelInfinispanEventData", eventData);
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOGGER.error("Error processing event ", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doStart() throws Exception {
        super.doStart();
        BasicCacheContainer cacheContainer = this.configuration.getCacheContainer();
        this.cache = InfinispanUtil.getCache(this.configuration.getCacheContainer(), this.configuration.getCacheName());
        if (this.configuration.hasQueryBuilder()) {
            if (!InfinispanUtil.isRemote(this.cache)) throw new IllegalArgumentException("Can't run continuous queries against embedded cache (" + this.cache.getName() + ")");
            RemoteCache<Object, Object> remoteCache = InfinispanUtil.asRemote(this.cache);
            Query query = InfinispanRemoteOperation.buildQuery(this.configuration.getQueryBuilder(), remoteCache);
            this.continuousQuery = Search.getContinuousQuery(remoteCache);
            this.continuousQuery.addContinuousQueryListener(query, (ContinuousQueryListener)new ContinuousQueryEventListener(this.cache.getName()));
            return;
        } else {
            if (InfinispanUtil.isEmbedded(cacheContainer)) {
                this.consumerHandler = InfinispanConsumerEmbeddedHandler.INSTANCE;
            } else {
                if (!InfinispanUtil.isRemote(cacheContainer)) throw new UnsupportedOperationException("Consumer not support for CacheContainer: " + cacheContainer);
                this.consumerHandler = InfinispanConsumerRemoteHandler.INSTANCE;
            }
            this.listener = this.consumerHandler.start(this);
        }
    }

    protected void doStop() throws Exception {
        if (this.continuousQuery != null) {
            this.continuousQuery.removeAllListeners();
        }
        if (this.consumerHandler != null) {
            this.consumerHandler.stop(this);
        }
        super.doStop();
    }

    public BasicCache<Object, Object> getCache() {
        return this.cache;
    }

    public InfinispanEventListener getListener() {
        return this.listener;
    }

    public InfinispanConfiguration getConfiguration() {
        return this.configuration;
    }

    private class ContinuousQueryEventListener
    implements ContinuousQueryListener<Object, Object> {
        private final String cacheName;

        public ContinuousQueryEventListener(String cacheName) {
            this.cacheName = cacheName;
        }

        public void resultJoining(Object key, Object value) {
            InfinispanConsumer.this.processEvent("CacheEntryJoining", false, this.cacheName, key, value);
        }

        public void resultLeaving(Object key) {
            InfinispanConsumer.this.processEvent("CacheEntryLeaving", false, this.cacheName, key);
        }
    }
}

