/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;

public final class InfinispanUtil {
    private InfinispanUtil() {
    }

    public static boolean isEmbedded(BasicCacheContainer container) {
        try {
            return container instanceof EmbeddedCacheManager;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static <K, V> boolean isEmbedded(BasicCache<K, V> cache) {
        try {
            return cache instanceof Cache;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isRemote(BasicCacheContainer container) {
        try {
            return container instanceof RemoteCacheManager;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static RemoteCacheManager asRemote(BasicCacheContainer container) {
        return (RemoteCacheManager)RemoteCacheManager.class.cast(container);
    }

    public static <K, V> boolean isRemote(BasicCache<K, V> cache) {
        try {
            return cache instanceof RemoteCache;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static <K, V> RemoteCache<K, V> asRemote(BasicCache<K, V> cache) {
        return (RemoteCache)RemoteCache.class.cast(cache);
    }

    public static <K, V> BasicCache<K, V> ignoreReturnValuesCache(BasicCache<K, V> cache) {
        if (InfinispanUtil.isEmbedded(cache)) {
            return ((Cache)cache).getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        }
        return cache;
    }

    public static boolean isInHeaderEmpty(Exchange exchange, String header) {
        return ObjectHelper.isEmpty((Object)exchange.getIn().getHeader(header));
    }

    public static BasicCache<Object, Object> getCache(BasicCacheContainer cacheContainer, String cacheName) {
        return ObjectHelper.isEmpty((Object)cacheName) ? cacheContainer.getCache() : cacheContainer.getCache(cacheName);
    }
}

