/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.Set;
import org.apache.camel.component.infinispan.InfinispanConsumer;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Listener(clustered=false, sync=true)
public class InfinispanSyncLocalEventListener
extends InfinispanEventListener {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public InfinispanSyncLocalEventListener(InfinispanConsumer infinispanConsumer, Set<String> eventTypes) {
        super(infinispanConsumer, eventTypes);
    }

    @CacheEntryActivated
    @CacheEntryCreated
    @CacheEntryInvalidated
    @CacheEntryLoaded
    @CacheEntryModified
    @CacheEntryPassivated
    @CacheEntryRemoved
    @CacheEntryVisited
    @CacheEntryExpired
    public void processEvent(CacheEntryEvent<Object, Object> event) {
        this.logger.trace("Received CacheEntryEvent [{}]", event);
        this.dispatch(event.getType().toString(), event.isPre(), event.getCache().getName(), event.getKey());
    }

    private void dispatch(String eventType, boolean isPre, String cacheName, Object key) {
        if (this.isAccepted(eventType)) {
            this.infinispanConsumer.processEvent(eventType, isPre, cacheName, key, null);
        }
    }
}

