/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.carrotsearch.hppc.IntObjectHashMap;
import java.io.IOException;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericFloatTokenizer;

public class NumericFloatAnalyzer
extends NumericAnalyzer<NumericFloatTokenizer> {
    private static final IntObjectHashMap<NamedAnalyzer> builtIn = new IntObjectHashMap();
    private final int precisionStep;

    public static NamedAnalyzer buildNamedAnalyzer(int precisionStep) {
        NamedAnalyzer namedAnalyzer = (NamedAnalyzer)((Object)builtIn.get(precisionStep));
        if (namedAnalyzer == null) {
            namedAnalyzer = new NamedAnalyzer("_float/" + precisionStep, AnalyzerScope.INDEX, new NumericFloatAnalyzer(precisionStep));
        }
        return namedAnalyzer;
    }

    public NumericFloatAnalyzer(int precisionStep) {
        this.precisionStep = precisionStep;
    }

    @Override
    protected NumericFloatTokenizer createNumericTokenizer(char[] buffer) throws IOException {
        return new NumericFloatTokenizer(this.precisionStep, buffer);
    }

    static {
        builtIn.put(Integer.MAX_VALUE, (Object)new NamedAnalyzer("_float/max", AnalyzerScope.GLOBAL, new NumericFloatAnalyzer(Integer.MAX_VALUE)));
        for (int i = 0; i <= 64; i += 4) {
            builtIn.put(i, (Object)new NamedAnalyzer("_float/" + i, AnalyzerScope.GLOBAL, new NumericFloatAnalyzer(i)));
        }
    }
}

