/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ExchangeHelper;

public final class ShareUnitOfWorkAggregationStrategy
implements AggregationStrategy {
    private final AggregationStrategy strategy;

    public ShareUnitOfWorkAggregationStrategy(AggregationStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Exchange answer = this.strategy.aggregate(oldExchange, newExchange);
        this.propagateFailure(answer, newExchange);
        return answer;
    }

    protected void propagateFailure(Exchange answer, Exchange newExchange) {
        boolean exceptionHandled = ExchangeHelper.hasExceptionBeenHandledByErrorHandler(newExchange);
        if (newExchange.isFailed() || newExchange.isRollbackOnly() || exceptionHandled) {
            if (newExchange.getException() != null) {
                answer.setException(newExchange.getException());
            }
            if (newExchange.getProperty("CamelExceptionCaught") != null) {
                answer.setProperty("CamelExceptionCaught", newExchange.getProperty("CamelExceptionCaught"));
            }
            if (newExchange.getProperty("CamelFailureEndpoint") != null) {
                answer.setProperty("CamelFailureEndpoint", newExchange.getProperty("CamelFailureEndpoint"));
            }
            if (newExchange.getProperty("CamelFailureRouteId") != null) {
                answer.setProperty("CamelFailureRouteId", newExchange.getProperty("CamelFailureRouteId"));
            }
            if (newExchange.getProperty("CamelErrorHandlerHandled") != null) {
                answer.setProperty("CamelErrorHandlerHandled", newExchange.getProperty("CamelErrorHandlerHandled"));
            }
            if (newExchange.getProperty("CamelFailureHandled") != null) {
                answer.setProperty("CamelFailureHandled", newExchange.getProperty("CamelFailureHandled"));
            }
        }
    }

    public String toString() {
        return "ShareUnitOfWorkAggregationStrategy";
    }
}

