/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AmexExpressCheckoutCard;
import com.braintreegateway.AndroidPayCard;
import com.braintreegateway.ApplePayCard;
import com.braintreegateway.CoinbaseAccount;
import com.braintreegateway.Configuration;
import com.braintreegateway.CreditCard;
import com.braintreegateway.EuropeBankAccount;
import com.braintreegateway.PayPalAccount;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.PaymentMethodRequest;
import com.braintreegateway.Result;
import com.braintreegateway.UnknownPaymentMethod;
import com.braintreegateway.VenmoAccount;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethodGateway {
    private Http http;
    private Configuration configuration;

    public PaymentMethodGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<? extends PaymentMethod> create(PaymentMethodRequest request) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods", request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> update(String token, PaymentMethodRequest request) {
        NodeWrapper response = this.http.put(this.configuration.getMerchantPath() + "/payment_methods/any/" + token, request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> delete(String token) {
        this.http.delete(this.configuration.getMerchantPath() + "/payment_methods/any/" + token);
        return new Result();
    }

    public PaymentMethod find(String token) {
        if (token == null || token.trim().equals("")) {
            throw new NotFoundException();
        }
        NodeWrapper response = this.http.get(this.configuration.getMerchantPath() + "/payment_methods/any/" + token);
        return this.parseResponse(response).getTarget();
    }

    public Result<? extends PaymentMethod> parseResponse(NodeWrapper response) {
        if (response.getElementName() == "paypal-account") {
            return new Result<PayPalAccount>(response, PayPalAccount.class);
        }
        if (response.getElementName() == "credit-card") {
            return new Result<CreditCard>(response, CreditCard.class);
        }
        if (response.getElementName() == "europe-bank-account") {
            return new Result<EuropeBankAccount>(response, EuropeBankAccount.class);
        }
        if (response.getElementName() == "apple-pay-card") {
            return new Result<ApplePayCard>(response, ApplePayCard.class);
        }
        if (response.getElementName() == "android-pay-card") {
            return new Result<AndroidPayCard>(response, AndroidPayCard.class);
        }
        if (response.getElementName() == "amex-express-checkout-card") {
            return new Result<AmexExpressCheckoutCard>(response, AmexExpressCheckoutCard.class);
        }
        if (response.getElementName() == "coinbase-account") {
            return new Result<CoinbaseAccount>(response, CoinbaseAccount.class);
        }
        if (response.getElementName() == "venmo-account") {
            return new Result<VenmoAccount>(response, VenmoAccount.class);
        }
        return new Result<UnknownPaymentMethod>(response, UnknownPaymentMethod.class);
    }
}

