/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TypeConverter;
import org.apache.camel.cdi.CdiCamelExtension;
import org.apache.camel.cdi.CdiEventEndpoint;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.Mock;
import org.apache.camel.cdi.Uri;
import org.apache.camel.component.mock.MockEndpoint;

final class CdiCamelFactory {
    CdiCamelFactory() {
    }

    @Produces
    private static TypeConverter typeConverter(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        return CdiCamelFactory.selectContext(ip, instance, extension).getTypeConverter();
    }

    @Uri(value="")
    @Produces
    private static ProducerTemplate producerTemplate(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        Uri uri = CdiSpiHelper.getQualifierByType(ip, Uri.class);
        try {
            CamelContext context = uri.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(uri.context(), instance);
            ProducerTemplate producerTemplate = context.createProducerTemplate();
            Endpoint endpoint = context.getEndpoint(uri.value(), Endpoint.class);
            producerTemplate.setDefaultEndpoint(endpoint);
            return producerTemplate;
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting producer template annotated with " + uri + " into " + ip, (Throwable)cause);
        }
    }

    @Produces
    @Typed(value={MockEndpoint.class})
    private static MockEndpoint mockEndpointFromMember(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        String uri = "mock:" + ip.getMember().getName();
        try {
            return (MockEndpoint)CdiCamelFactory.selectContext(ip, instance, extension).getEndpoint(uri, MockEndpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting mock endpoint into " + ip, (Throwable)cause);
        }
    }

    @Uri(value="")
    @Produces
    @Typed(value={MockEndpoint.class})
    private static MockEndpoint mockEndpointFromUri(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        Uri uri = CdiSpiHelper.getQualifierByType(ip, Uri.class);
        try {
            CamelContext context = uri.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(uri.context(), instance);
            return (MockEndpoint)context.getEndpoint(uri.value(), MockEndpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting mock endpoint annotated with " + uri + " into " + ip, (Throwable)cause);
        }
    }

    @Mock(value="")
    @Produces
    @Typed(value={MockEndpoint.class})
    private static MockEndpoint createMockEndpoint(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        Mock mock = CdiSpiHelper.getQualifierByType(ip, Mock.class);
        try {
            CamelContext context = mock.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(mock.context(), instance);
            return (MockEndpoint)context.getEndpoint(mock.value(), MockEndpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting mock endpoint annotated with " + mock + " into " + ip, (Throwable)cause);
        }
    }

    @Uri(value="")
    @Produces
    private static Endpoint endpoint(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        Uri uri = CdiSpiHelper.getQualifierByType(ip, Uri.class);
        try {
            CamelContext context = uri.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(uri.context(), instance);
            return context.getEndpoint(uri.value(), Endpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting endpoint annotated with " + uri + " into " + ip, (Throwable)cause);
        }
    }

    @Produces
    private static <T> CdiEventEndpoint<T> cdiEventEndpoint(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension, @Any Event<Object> event) throws Exception {
        String uri;
        CamelContext context = CdiCamelFactory.selectContext(ip, instance, extension);
        Object type = Object.class;
        if (ip.getType() instanceof ParameterizedType) {
            type = ((ParameterizedType)ip.getType()).getActualTypeArguments()[0];
        }
        if (context.hasEndpoint(uri = CdiCamelFactory.eventEndpointUri(type, ip.getQualifiers())) == null) {
            TypeLiteral literal = new TypeLiteral<T>(){};
            for (Field field : TypeLiteral.class.getDeclaredFields()) {
                if (!field.getType().equals(Type.class)) continue;
                field.setAccessible(true);
                field.set(literal, type);
                break;
            }
            context.addEndpoint(uri, new CdiEventEndpoint(event.select(literal, ip.getQualifiers().toArray(new Annotation[ip.getQualifiers().size()])), uri, context, extension.getObserverMethod(ip)));
        }
        return (CdiEventEndpoint)context.getEndpoint(uri, CdiEventEndpoint.class);
    }

    private static <T extends CamelContext> T selectContext(String name, Instance<T> instance) {
        for (CamelContext context : instance) {
            if (!name.equals(context.getName())) continue;
            return (T)context;
        }
        throw new UnsatisfiedResolutionException("No Camel context with name [" + name + "] is deployed!");
    }

    private static <T extends CamelContext> T selectContext(InjectionPoint ip, Instance<T> instance, CdiCamelExtension extension) {
        HashSet qualifiers = new HashSet(ip.getQualifiers());
        qualifiers.retainAll(extension.getContextQualifiers());
        if (qualifiers.isEmpty() && !instance.select(new Annotation[]{DefaultLiteral.INSTANCE}).isUnsatisfied()) {
            return (T)((CamelContext)instance.select(new Annotation[]{DefaultLiteral.INSTANCE}).get());
        }
        return (T)((CamelContext)instance.select(qualifiers.toArray(new Annotation[qualifiers.size()])).get());
    }

    private static String eventEndpointUri(Type type, Set<Annotation> qualifiers) {
        String uri = "cdi-event://" + CdiCamelFactory.authorityFromType(type);
        StringBuilder parameters = new StringBuilder();
        Iterator<Annotation> it = qualifiers.iterator();
        while (it.hasNext()) {
            parameters.append(it.next().annotationType().getCanonicalName());
            if (!it.hasNext()) continue;
            parameters.append("%2C");
        }
        if (parameters.length() > 0) {
            uri = uri + "?qualifiers=" + parameters.toString();
        }
        return uri;
    }

    private static String authorityFromType(Type type) {
        if (type instanceof Class) {
            return ((Class)Class.class.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder(CdiCamelFactory.authorityFromType(pt.getRawType()));
            Iterator<Type> it = Arrays.asList(pt.getActualTypeArguments()).iterator();
            builder.append("%3C");
            while (it.hasNext()) {
                builder.append(CdiCamelFactory.authorityFromType(it.next()));
                if (!it.hasNext()) continue;
                builder.append("%2C");
            }
            builder.append("%3E");
            return builder.toString();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return CdiCamelFactory.authorityFromType(arrayType.getGenericComponentType()) + "%5B%5D";
        }
        throw new IllegalArgumentException("Cannot create URI authority for event type [" + type + "]");
    }
}

