/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.main.MainSupport;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class Main
extends MainSupport {
    private static final Logger LOG;
    private static Main instance;
    private CdiContainer cdiContainer;

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        BeanManager manager = this.cdiContainer.getBeanManager();
        Bean bean = manager.resolve(manager.getBeans(CamelContext.class, new Annotation[0]));
        if (bean == null) {
            throw new UnsatisfiedResolutionException("No default Camel context is deployed, cannot create default ProducerTemplate!");
        }
        CamelContext context = (CamelContext)manager.getReference(bean, CamelContext.class, manager.createCreationalContext((Contextual)bean));
        return context.createProducerTemplate();
    }

    protected Map<String, CamelContext> getCamelContextMap() {
        BeanManager manager = this.cdiContainer.getBeanManager();
        HashMap<String, CamelContext> answer = new HashMap<String, CamelContext>();
        for (Bean bean : manager.getBeans(CamelContext.class, new Annotation[]{AnyLiteral.INSTANCE})) {
            CamelContext context = (CamelContext)manager.getReference(bean, CamelContext.class, manager.createCreationalContext((Contextual)bean));
            answer.put(context.getName(), context);
        }
        return answer;
    }

    protected void doStart() throws Exception {
        CdiContainer container = CdiContainerLoader.getCdiContainer();
        container.boot();
        container.getContextControl().startContexts();
        this.cdiContainer = container;
        super.doStart();
        this.postProcessContext();
        this.warnIfNoCamelFound();
    }

    private void warnIfNoCamelFound() {
        BeanManager manager = this.cdiContainer.getBeanManager();
        Set contexts = manager.getBeans(CamelContext.class, new Annotation[0]);
        if (contexts.size() == 1 && BeanManagerHelper.getReference(manager, CamelContext.class, (Bean)contexts.iterator().next()).getRoutes().isEmpty()) {
            LOG.warn("Camel CDI main has started with no Camel routes! You may add some RouteBuilder beans to your project.");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.cdiContainer != null) {
            this.cdiContainer.shutdown();
        }
    }

    static {
        System.setProperty("org.jboss.weld.se.shutdownHook", String.valueOf(Boolean.FALSE));
        LOG = LoggerFactory.getLogger(Main.class);
    }
}

