/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree;

import com.braintreegateway.BraintreeGateway;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.braintree.BraintreeConfiguration;
import org.apache.camel.component.braintree.BraintreeEndpoint;
import org.apache.camel.component.braintree.internal.BraintreeApiCollection;
import org.apache.camel.component.braintree.internal.BraintreeApiName;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

public class BraintreeComponent
extends AbstractApiComponent<BraintreeApiName, BraintreeConfiguration, BraintreeApiCollection> {
    private final Map<String, BraintreeGateway> gateways = new HashMap<String, BraintreeGateway>();

    public BraintreeComponent() {
        super(BraintreeEndpoint.class, BraintreeApiName.class, (ApiCollection)BraintreeApiCollection.getCollection());
    }

    public BraintreeComponent(CamelContext context) {
        super(context, BraintreeEndpoint.class, BraintreeApiName.class, (ApiCollection)BraintreeApiCollection.getCollection());
    }

    protected BraintreeApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return BraintreeApiName.fromValue(apiNameStr);
    }

    protected Endpoint createEndpoint(String uri, String methodName, BraintreeApiName apiName, BraintreeConfiguration endpointConfiguration) {
        return new BraintreeEndpoint(uri, this, apiName, methodName, endpointConfiguration, this.getGateway(endpointConfiguration));
    }

    public void setConfiguration(BraintreeConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public BraintreeConfiguration getConfiguration() {
        return (BraintreeConfiguration)super.getConfiguration();
    }

    private synchronized BraintreeGateway getGateway(BraintreeConfiguration configuration) {
        BraintreeGateway gateway = this.gateways.get(configuration.getMerchantId());
        if (gateway == null) {
            gateway = configuration.newBraintreeGateway();
            this.gateways.put(configuration.getMerchantId(), gateway);
        }
        return gateway;
    }
}

