/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.SalesforceExchange;
import org.apache.camel.component.salesforce.internal.client.SalesforceSecurityListener;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBase
implements SalesforceSession.SalesforceSessionListener,
Service {
    protected static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    protected static final String APPLICATION_XML_UTF8 = "application/xml;charset=utf-8";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final HttpClient httpClient;
    protected final SalesforceSession session;
    protected final String version;
    protected String accessToken;
    protected String instanceUrl;

    public AbstractClientBase(String version, SalesforceSession session, HttpClient httpClient) throws SalesforceException {
        this.version = version;
        this.session = session;
        this.httpClient = httpClient;
    }

    public void start() throws Exception {
        this.accessToken = this.session.getAccessToken();
        if (this.accessToken == null) {
            this.accessToken = this.session.login(this.accessToken);
        }
        this.instanceUrl = this.session.getInstanceUrl();
        this.session.addListener(this);
    }

    public void stop() throws Exception {
        this.session.removeListener(this);
    }

    @Override
    public void onLogin(String accessToken, String instanceUrl) {
        if (!accessToken.equals(this.accessToken)) {
            this.accessToken = accessToken;
            this.instanceUrl = instanceUrl;
        }
    }

    @Override
    public void onLogout() {
    }

    protected SalesforceExchange getContentExchange(String method, String url) {
        SalesforceExchange get = new SalesforceExchange();
        get.setMethod(method);
        get.setURL(url);
        get.setClient(this);
        return get;
    }

    protected void doHttpRequest(final ContentExchange request, final ClientResponseCallback callback) {
        SalesforceSecurityListener securityListener;
        try {
            boolean isHttps = "https".equals(String.valueOf(request.getScheme()));
            securityListener = new SalesforceSecurityListener(this.httpClient.getDestination(request.getAddress(), isHttps), (HttpExchange)request, this.session, this.accessToken){
                private String reason;

                @Override
                public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
                    super.onResponseStatus(version, status, reason);
                    this.reason = reason.toString("ISO-8859-1");
                }

                @Override
                protected SalesforceException createExceptionResponse() {
                    int responseStatus = request.getResponseStatus();
                    if (responseStatus < 200 || responseStatus >= 300) {
                        String msg = String.format("Error {%s:%s} executing {%s:%s}", responseStatus, this.reason, request.getMethod(), request.getRequestURI());
                        return new SalesforceException(msg, responseStatus, (Throwable)((Object)AbstractClientBase.this.createRestException(request, this.reason)));
                    }
                    return super.createExceptionResponse();
                }
            };
        }
        catch (IOException e) {
            callback.onResponse(null, new SalesforceException(String.format("Error registering security listener: %s", e.getMessage()), e));
            return;
        }
        request.setEventListener((HttpEventListener)new HttpEventListenerWrapper(request.getEventListener(), true){

            public void onConnectionFailed(Throwable ex) {
                super.onConnectionFailed(ex);
                callback.onResponse(null, new SalesforceException("Connection error: " + ex.getMessage(), ex));
            }

            public void onException(Throwable ex) {
                super.onException(ex);
                callback.onResponse(null, new SalesforceException("Unexpected exception: " + ex.getMessage(), ex));
            }

            public void onExpire() {
                super.onExpire();
                callback.onResponse(null, new SalesforceException("Request expired", null));
            }

            public void onResponseComplete() throws IOException {
                super.onResponseComplete();
                SalesforceException e = securityListener.getExceptionResponse();
                if (e != null) {
                    callback.onResponse(null, e);
                } else {
                    byte[] bytes = request.getResponseContentBytes();
                    callback.onResponse(bytes != null ? new ByteArrayInputStream(bytes) : null, null);
                }
            }
        });
        securityListener.setEventListener(request.getEventListener());
        request.setEventListener((HttpEventListener)securityListener);
        try {
            this.httpClient.send((HttpExchange)request);
        }
        catch (IOException e) {
            String msg = "Unexpected Error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    protected abstract void setAccessToken(HttpExchange var1);

    protected abstract SalesforceException createRestException(ContentExchange var1, String var2);

    protected static interface ClientResponseCallback {
        public void onResponse(InputStream var1, SalesforceException var2);
    }
}

