/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz2;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.component.quartz2.CamelJob;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.component.quartz2.QuartzConsumer;
import org.apache.camel.component.quartz2.QuartzHelper;
import org.apache.camel.component.quartz2.StatefulCamelJob;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.quartz.Calendar;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="quartz2", title="Quartz2", syntax="quartz2:groupName/triggerName", consumerOnly=true, consumerClass=QuartzComponent.class, label="scheduling")
public class QuartzEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzEndpoint.class);
    private TriggerKey triggerKey;
    private LoadBalancer consumerLoadBalancer;
    private final AtomicBoolean jobAdded = new AtomicBoolean(false);
    private final AtomicBoolean jobPaused = new AtomicBoolean(false);
    @UriPath(description="The quartz group name to use. The combination of group name and timer name should be unique.", defaultValue="Camel")
    private String groupName;
    @UriPath
    @Metadata(required="true")
    private String triggerName;
    @UriParam
    private String cron;
    @UriParam
    private boolean stateful;
    @UriParam
    private boolean fireNow;
    @UriParam(defaultValue="true")
    private boolean deleteJob = true;
    @UriParam
    private boolean pauseJob;
    @UriParam
    private boolean durableJob;
    @UriParam
    private boolean recoverableJob;
    @UriParam(defaultValue="500")
    private long triggerStartDelay = 500L;
    @UriParam
    private int startDelayedSeconds;
    @UriParam(defaultValue="true")
    private boolean autoStartScheduler = true;
    @UriParam
    private boolean usingFixedCamelContextName;
    @UriParam
    private boolean prefixJobNameWithEndpointId;
    @UriParam(prefix="trigger.", multiValue=true)
    private Map<String, Object> triggerParameters;
    @UriParam(prefix="job.", multiValue=true)
    private Map<String, Object> jobParameters;
    @UriParam
    private Calendar customCalendar;

    public QuartzEndpoint(String uri, QuartzComponent quartzComponent) {
        super(uri, (Component)quartzComponent);
    }

    public String getGroupName() {
        return this.triggerKey.getName();
    }

    public String getTriggerName() {
        return this.triggerKey.getName();
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getCron() {
        return this.cron;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isFireNow() {
        return this.fireNow;
    }

    public long getTriggerStartDelay() {
        return this.triggerStartDelay;
    }

    public boolean isDeleteJob() {
        return this.deleteJob;
    }

    public boolean isPauseJob() {
        return this.pauseJob;
    }

    public void setPauseJob(boolean pauseJob) {
        this.pauseJob = pauseJob;
    }

    public void setTriggerStartDelay(long triggerStartDelay) {
        this.triggerStartDelay = triggerStartDelay;
    }

    public void setDeleteJob(boolean deleteJob) {
        this.deleteJob = deleteJob;
    }

    public void setFireNow(boolean fireNow) {
        this.fireNow = fireNow;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public boolean isDurableJob() {
        return this.durableJob;
    }

    public void setDurableJob(boolean durableJob) {
        this.durableJob = durableJob;
    }

    public boolean isRecoverableJob() {
        return this.recoverableJob;
    }

    public void setRecoverableJob(boolean recoverableJob) {
        this.recoverableJob = recoverableJob;
    }

    public boolean isUsingFixedCamelContextName() {
        return this.usingFixedCamelContextName;
    }

    public void setUsingFixedCamelContextName(boolean usingFixedCamelContextName) {
        this.usingFixedCamelContextName = usingFixedCamelContextName;
    }

    public LoadBalancer getConsumerLoadBalancer() {
        if (this.consumerLoadBalancer == null) {
            this.consumerLoadBalancer = new RoundRobinLoadBalancer();
        }
        return this.consumerLoadBalancer;
    }

    public void setConsumerLoadBalancer(LoadBalancer consumerLoadBalancer) {
        this.consumerLoadBalancer = consumerLoadBalancer;
    }

    public Map<String, Object> getTriggerParameters() {
        return this.triggerParameters;
    }

    public void setTriggerParameters(Map<String, Object> triggerParameters) {
        this.triggerParameters = triggerParameters;
    }

    public Map<String, Object> getJobParameters() {
        return this.jobParameters;
    }

    public void setJobParameters(Map<String, Object> jobParameters) {
        this.jobParameters = jobParameters;
    }

    public int getStartDelayedSeconds() {
        return this.startDelayedSeconds;
    }

    public void setStartDelayedSeconds(int startDelayedSeconds) {
        this.startDelayedSeconds = startDelayedSeconds;
    }

    public boolean isAutoStartScheduler() {
        return this.autoStartScheduler;
    }

    public void setAutoStartScheduler(boolean autoStartScheduler) {
        this.autoStartScheduler = autoStartScheduler;
    }

    public boolean isPrefixJobNameWithEndpointId() {
        return this.prefixJobNameWithEndpointId;
    }

    public void setPrefixJobNameWithEndpointId(boolean prefixJobNameWithEndpointId) {
        this.prefixJobNameWithEndpointId = prefixJobNameWithEndpointId;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public TriggerKey getTriggerKey() {
        return this.triggerKey;
    }

    public void setTriggerKey(TriggerKey triggerKey) {
        this.triggerKey = triggerKey;
    }

    public Calendar getCustomCalendar() {
        return this.customCalendar;
    }

    public void setCustomCalendar(Calendar customCalendar) {
        this.customCalendar = customCalendar;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Quartz producer is not supported.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        QuartzConsumer result = new QuartzConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)result);
        return result;
    }

    public boolean isSingleton() {
        return false;
    }

    protected void doStart() throws Exception {
        if (this.isDeleteJob() && this.isPauseJob()) {
            throw new IllegalArgumentException("Cannot have both options deleteJob and pauseJob enabled");
        }
        if (ObjectHelper.isNotEmpty((Object)this.customCalendar)) {
            this.getComponent().getScheduler().addCalendar("CamelQuartzCustomCalendar", this.customCalendar, true, false);
        }
        this.addJobInScheduler();
    }

    protected void doStop() throws Exception {
        this.removeJobInScheduler();
    }

    private void removeJobInScheduler() throws Exception {
        Scheduler scheduler = this.getComponent().getScheduler();
        if (scheduler == null) {
            return;
        }
        if (this.deleteJob) {
            boolean isClustered = scheduler.getMetaData().isJobStoreClustered();
            if (!scheduler.isShutdown() && !isClustered) {
                LOG.info("Deleting job {}", (Object)this.triggerKey);
                scheduler.unscheduleJob(this.triggerKey);
                this.jobAdded.set(false);
            }
        } else if (this.pauseJob) {
            this.pauseTrigger();
        }
        AtomicInteger number = (AtomicInteger)scheduler.getContext().get((Object)"CamelQuartzJobsCount");
        if (number != null) {
            number.decrementAndGet();
        }
    }

    private void addJobInScheduler() throws Exception {
        AtomicInteger number;
        Trigger trigger;
        JobDetail jobDetail;
        Scheduler scheduler;
        block9: {
            boolean triggerExisted;
            scheduler = this.getComponent().getScheduler();
            Trigger oldTrigger = scheduler.getTrigger(this.triggerKey);
            boolean bl = triggerExisted = oldTrigger != null;
            if (triggerExisted && !this.isRecoverableJob()) {
                this.ensureNoDupTriggerKey();
            }
            jobDetail = this.createJobDetail();
            trigger = this.createTrigger(jobDetail);
            QuartzHelper.updateJobDataMap(this.getCamelContext(), jobDetail, this.getEndpointUri(), this.isUsingFixedCamelContextName());
            if (triggerExisted) {
                if (this.hasTriggerChanged(oldTrigger, trigger)) {
                    scheduler.rescheduleJob(this.triggerKey, trigger);
                }
            } else {
                try {
                    scheduler.scheduleJob(jobDetail, trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (!this.getComponent().isClustered()) {
                        throw ex;
                    }
                    trigger = scheduler.getTrigger(this.triggerKey);
                    if (trigger != null) break block9;
                    throw new SchedulerException("Trigger could not be found in quartz scheduler.");
                }
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Job {} (triggerType={}, jobClass={}) is scheduled. Next fire date is {}", new Object[]{trigger.getKey(), trigger.getClass().getSimpleName(), jobDetail.getJobClass().getSimpleName(), trigger.getNextFireTime()});
        }
        if ((number = (AtomicInteger)scheduler.getContext().get((Object)"CamelQuartzJobsCount")) != null) {
            number.incrementAndGet();
        }
        this.jobAdded.set(true);
    }

    private boolean hasTriggerChanged(Trigger oldTrigger, Trigger newTrigger) {
        if (newTrigger instanceof CronTrigger && oldTrigger instanceof CronTrigger) {
            CronTrigger newCron = (CronTrigger)newTrigger;
            CronTrigger oldCron = (CronTrigger)oldTrigger;
            return !newCron.getCronExpression().equals(oldCron.getCronExpression());
        }
        if (newTrigger instanceof SimpleTrigger && oldTrigger instanceof SimpleTrigger) {
            SimpleTrigger newSimple = (SimpleTrigger)newTrigger;
            SimpleTrigger oldSimple = (SimpleTrigger)oldTrigger;
            return newSimple.getRepeatInterval() != oldSimple.getRepeatInterval() || newSimple.getRepeatCount() != oldSimple.getRepeatCount();
        }
        return !newTrigger.getClass().equals(oldTrigger.getClass()) || !newTrigger.equals((Object)oldTrigger);
    }

    private void ensureNoDupTriggerKey() {
        for (Route route : this.getCamelContext().getRoutes()) {
            QuartzEndpoint quartzEndpoint;
            TriggerKey checkTriggerKey;
            if (!(route.getEndpoint() instanceof QuartzEndpoint) || !this.triggerKey.equals((Object)(checkTriggerKey = (quartzEndpoint = (QuartzEndpoint)route.getEndpoint()).getTriggerKey()))) continue;
            throw new IllegalArgumentException("Trigger key " + this.triggerKey + " is already in use by " + (Object)((Object)quartzEndpoint));
        }
    }

    private Trigger createTrigger(JobDetail jobDetail) throws Exception {
        Trigger result;
        Date startTime = new Date();
        if (this.getComponent().getScheduler().isStarted()) {
            startTime = new Date(System.currentTimeMillis() + this.triggerStartDelay);
        }
        if (this.cron != null) {
            LOG.debug("Creating CronTrigger: {}", (Object)this.cron);
            String timeZone = (String)this.triggerParameters.get("timeZone");
            if (timeZone != null) {
                result = ObjectHelper.isNotEmpty((Object)this.customCalendar) ? TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed().inTimeZone(TimeZone.getTimeZone(timeZone))).modifiedByCalendar("CamelQuartzCustomCalendar").build() : TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed().inTimeZone(TimeZone.getTimeZone(timeZone))).build();
                jobDetail.getJobDataMap().put("CamelQuartzTriggerCronTimeZone", timeZone);
            } else {
                result = ObjectHelper.isNotEmpty((Object)this.customCalendar) ? TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed()).modifiedByCalendar("CamelQuartzCustomCalendar").build() : TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed()).build();
            }
            jobDetail.getJobDataMap().put("CamelQuartzTriggerType", "cron");
            jobDetail.getJobDataMap().put("CamelQuartzTriggerCronExpression", this.cron);
        } else {
            LOG.debug("Creating SimpleTrigger.");
            int repeat = -1;
            String repeatString = (String)this.triggerParameters.get("repeatCount");
            if (repeatString != null) {
                repeat = (Integer)EndpointHelper.resolveParameter((CamelContext)this.getCamelContext(), (String)repeatString, Integer.class);
                this.triggerParameters.put("repeatCount", repeat);
            }
            long interval = 1000L;
            String intervalString = (String)this.triggerParameters.get("repeatInterval");
            if (intervalString != null) {
                interval = (Long)EndpointHelper.resolveParameter((CamelContext)this.getCamelContext(), (String)intervalString, Long.class);
                this.triggerParameters.put("repeatInterval", interval);
            }
            TriggerBuilder triggerBuilder = ObjectHelper.isNotEmpty((Object)this.customCalendar) ? TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow().withRepeatCount(repeat).withIntervalInMilliseconds(interval)).modifiedByCalendar("CamelQuartzCustomCalendar") : TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow().withRepeatCount(repeat).withIntervalInMilliseconds(interval));
            if (this.fireNow) {
                triggerBuilder = triggerBuilder.startNow();
            }
            result = triggerBuilder.build();
            jobDetail.getJobDataMap().put("CamelQuartzTriggerType", "simple");
            jobDetail.getJobDataMap().put("CamelQuartzTriggerSimpleRepeatCounter", repeat);
            jobDetail.getJobDataMap().put("CamelQuartzTriggerSimpleRepeatInterval", interval);
        }
        if (this.triggerParameters != null && this.triggerParameters.size() > 0) {
            LOG.debug("Setting user extra triggerParameters {}", this.triggerParameters);
            this.setProperties(result, this.triggerParameters);
        }
        LOG.debug("Created trigger={}", (Object)result);
        return result;
    }

    private JobDetail createJobDetail() throws Exception {
        String name = this.triggerKey.getName();
        String group = this.triggerKey.getGroup();
        Class jobClass = this.stateful ? StatefulCamelJob.class : CamelJob.class;
        LOG.debug("Creating new {}.", (Object)jobClass.getSimpleName());
        JobBuilder builder = JobBuilder.newJob((Class)jobClass).withIdentity(name, group);
        if (this.durableJob) {
            builder = builder.storeDurably();
        }
        if (this.recoverableJob) {
            builder = builder.requestRecovery();
        }
        JobDetail result = builder.build();
        if (this.jobParameters != null && this.jobParameters.size() > 0) {
            LOG.debug("Setting user extra jobParameters {}", this.jobParameters);
            this.setProperties(result, this.jobParameters);
        }
        LOG.debug("Created jobDetail={}", (Object)result);
        return result;
    }

    public QuartzComponent getComponent() {
        return (QuartzComponent)super.getComponent();
    }

    public void pauseTrigger() throws Exception {
        Scheduler scheduler = this.getComponent().getScheduler();
        boolean isClustered = scheduler.getMetaData().isJobStoreClustered();
        if (this.jobPaused.get() || isClustered) {
            return;
        }
        this.jobPaused.set(true);
        if (!scheduler.isShutdown()) {
            LOG.info("Pausing trigger {}", (Object)this.triggerKey);
            scheduler.pauseTrigger(this.triggerKey);
        }
    }

    public void resumeTrigger() throws Exception {
        if (!this.jobPaused.get()) {
            return;
        }
        this.jobPaused.set(false);
        Scheduler scheduler = this.getComponent().getScheduler();
        if (scheduler != null) {
            LOG.info("Resuming trigger {}", (Object)this.triggerKey);
            scheduler.resumeTrigger(this.triggerKey);
        }
    }

    public void onConsumerStart(QuartzConsumer quartzConsumer) throws Exception {
        this.getConsumerLoadBalancer().addProcessor(quartzConsumer.getProcessor());
        if (!this.jobAdded.get()) {
            this.addJobInScheduler();
        } else {
            this.resumeTrigger();
        }
    }

    public void onConsumerStop(QuartzConsumer quartzConsumer) throws Exception {
        this.getConsumerLoadBalancer().removeProcessor(quartzConsumer.getProcessor());
        if (this.jobAdded.get()) {
            this.pauseTrigger();
        }
    }
}

