/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class KafkaConfiguration {
    @UriPath
    @Metadata(required="true")
    private String brokers;
    @UriParam
    @Metadata(required="true")
    private String topic;
    @UriParam
    private String groupId;
    @UriParam(defaultValue="org.apache.kafka.clients.producer.internals.DefaultPartitioner")
    private String partitioner = "org.apache.kafka.clients.producer.internals.DefaultPartitioner";
    @UriParam(label="consumer", defaultValue="10")
    private int consumerStreams = 10;
    @UriParam(label="consumer", defaultValue="1")
    private int consumersCount = 1;
    @UriParam(label="consumer", defaultValue="100")
    private int batchSize = 100;
    @UriParam(label="consumer", defaultValue="10000")
    private int barrierAwaitTimeoutMs = 10000;
    @UriParam
    private String clientId;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.common.serialization.StringDeserializer")
    private String keyDeserializer = "org.apache.kafka.common.serialization.StringDeserializer";
    @UriParam(label="consumer", defaultValue="org.apache.kafka.common.serialization.StringDeserializer")
    private String valueDeserializer = "org.apache.kafka.common.serialization.StringDeserializer";
    @UriParam(label="consumer", defaultValue="1024")
    private Integer fetchMinBytes = 1024;
    @UriParam(label="consumer", defaultValue="3000")
    private Integer heartbeatIntervalMs = 3000;
    @UriParam(label="consumer", defaultValue="1048576")
    private Integer maxPartitionFetchBytes = 0x100000;
    @UriParam(label="consumer", defaultValue="30000")
    private Integer sessionTimeoutMs = 30000;
    @UriParam(label="consumer", defaultValue="latest", enums="latest,earliest,none")
    private String autoOffsetReset = "latest";
    @UriParam(label="consumer", defaultValue="org.apache.kafka.clients.consumer.RangeAssignor")
    private String partitionAssignor = "org.apache.kafka.clients.consumer.RangeAssignor";
    @UriParam(label="consumer", defaultValue="40000")
    private Integer consumerRequestTimeoutMs = 40000;
    @UriParam(label="consumer", defaultValue="5000")
    private Integer autoCommitIntervalMs = 5000;
    @UriParam(label="consumer", defaultValue="true")
    private Boolean checkCrcs = true;
    @UriParam(label="consumer", defaultValue="500")
    private Integer fetchWaitMaxMs = 500;
    @UriParam(label="consumer")
    private String consumerId;
    @UriParam(label="consumer", defaultValue="true")
    private Boolean autoCommitEnable = true;
    @UriParam(label="producer", defaultValue="100")
    private Integer retryBackoffMs = 100;
    @UriParam(label="producer", defaultValue="10000")
    private Integer queueBufferingMaxMessages = 10000;
    @UriParam(label="producer")
    private String serializerClass;
    @UriParam(label="producer")
    private String keySerializerClass;
    @UriParam(label="producer", defaultValue="1")
    private Integer requestRequiredAcks = 1;
    @UriParam(label="producer", defaultValue="33554432")
    private Integer bufferMemorySize = 0x2000000;
    @UriParam(label="producer", defaultValue="none", enums="none,gzip,snappy,lz4")
    private String compressionCodec = "none";
    @UriParam(label="producer", defaultValue="0")
    private Integer retries = 0;
    @UriParam(label="producer")
    private String sslKeyPassword;
    @UriParam(label="producer")
    private String sslKeystoreLocation;
    @UriParam(label="producer")
    private String sslKeystorePassword;
    @UriParam(label="producer")
    private String sslTruststoreLocation;
    @UriParam(label="producer")
    private String sslTruststorePassword;
    @UriParam(label="producer", defaultValue="16384")
    private Integer producerBatchSize = 16384;
    @UriParam(label="producer", defaultValue="540000")
    private Integer connectionMaxIdleMs = 540000;
    @UriParam(label="producer", defaultValue="0")
    private Integer lingerMs = 0;
    @UriParam(label="producer", defaultValue="60000")
    private Integer maxBlockMs = 60000;
    @UriParam(label="producer", defaultValue="1048576")
    private Integer maxRequestSize = 0x100000;
    @UriParam(label="producer", defaultValue="32768")
    private Integer receiveBufferBytes = 32768;
    @UriParam(label="producer", defaultValue="30000")
    private Integer requestTimeoutMs = 30000;
    @UriParam(label="producer")
    private String saslKerberosServiceName;
    @UriParam(label="producer", defaultValue="PLAINTEXT")
    private String securityProtocol = "PLAINTEXT";
    @UriParam(label="producer", defaultValue="131072")
    private Integer sendBufferBytes = 131072;
    @UriParam(label="producer", defaultValue="TLSv1.2,TLSv1.1,TLSv1")
    private String sslEnabledProtocols = "TLSv1.2,TLSv1.1,TLSv1";
    @UriParam(label="producer", defaultValue="JKS")
    private String sslKeystoreType = "JKS";
    @UriParam(label="producer", defaultValue="TLS")
    private String sslProtocol = "TLS";
    @UriParam(label="producer")
    private String sslProvider;
    @UriParam(label="producer", defaultValue="JKS")
    private String sslTruststoreType = "JKS";
    @UriParam(label="producer", defaultValue="5")
    private Integer maxInFlightRequest = 5;
    @UriParam(label="producer", defaultValue="300000")
    private Integer metadataMaxAgeMs = 300000;
    @UriParam(label="producer")
    private String metricReporters;
    @UriParam(label="producer", defaultValue="2")
    private Integer noOfMetricsSample = 2;
    @UriParam(label="producer", defaultValue="30000")
    private Integer metricsSampleWindowMs = 30000;
    @UriParam(label="producer", defaultValue="50")
    private Integer reconnectBackoffMs = 50;
    @UriParam(label="producer", defaultValue="/usr/bin/kinit")
    private String kerberosInitCmd = "/usr/bin/kinit";
    @UriParam(label="producer", defaultValue="60000")
    private Integer kerberosBeforeReloginMinTime = 60000;
    @UriParam(label="producer", defaultValue="0.05")
    private Double kerberosRenewJitter = 0.05;
    @UriParam(label="producer", defaultValue="0.8")
    private Double kerberosRenewWindowFactor = 0.8;
    @UriParam(label="producer")
    private String sslCipherSuites;
    @UriParam(label="producer")
    private String sslEndpointAlgorithm;
    @UriParam(label="producer", defaultValue="SunX509")
    private String sslKeymanagerAlgorithm = "SunX509";
    @UriParam(label="producer", defaultValue="PKIX")
    private String sslTrustmanagerAlgorithm = "PKIX";

    public Properties createProducerProperties() {
        Properties props = new Properties();
        KafkaConfiguration.addPropertyIfNotNull(props, "key.serializer", this.getKeySerializerClass());
        KafkaConfiguration.addPropertyIfNotNull(props, "value.serializer", this.getSerializerClass());
        KafkaConfiguration.addPropertyIfNotNull(props, "acks", this.getRequestRequiredAcks());
        KafkaConfiguration.addPropertyIfNotNull(props, "buffer.memory", this.getBufferMemorySize());
        KafkaConfiguration.addPropertyIfNotNull(props, "compression.type", this.getCompressionCodec());
        KafkaConfiguration.addPropertyIfNotNull(props, "retries", this.getRetries());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.key.password", this.getSslKeyPassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.location", this.getSslKeystoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.password", this.getSslKeystorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.location", this.getSslTruststoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.password", this.getSslTruststorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.getRetries());
        KafkaConfiguration.addPropertyIfNotNull(props, "batch.size", this.getProducerBatchSize());
        KafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.getClientId());
        KafkaConfiguration.addPropertyIfNotNull(props, "connections.max.idle.ms", this.getConnectionMaxIdleMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "linger.ms", this.getLingerMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.block.ms", this.getMaxBlockMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.request.size", this.getMaxRequestSize());
        KafkaConfiguration.addPropertyIfNotNull(props, "partitioner.class", this.getPartitioner());
        KafkaConfiguration.addPropertyIfNotNull(props, "receive.buffer.bytes", this.getReceiveBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "request.timeout.ms", this.getRequestTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.service.name", this.getSaslKerberosServiceName());
        KafkaConfiguration.addPropertyIfNotNull(props, "security.protocol", this.getSecurityProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.getSendBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.enabled.protocols", this.getSslEnabledProtocols());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.type", this.getSslKeystoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.protocol", this.getSslProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.provider", this.getSslProvider());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.type", this.getSslTruststoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.in.flight.requests.per.connection", this.getMaxInFlightRequest());
        KafkaConfiguration.addPropertyIfNotNull(props, "metadata.max.age.ms", this.getMetadataMaxAgeMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "metric.reporters", this.getMetricReporters());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.num.samples", this.getNoOfMetricsSample());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.sample.window.ms", this.getMetricsSampleWindowMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.ms", this.getReconnectBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "retry.backoff.ms", this.getRetryBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.kinit.cmd", this.getKerberosInitCmd());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.min.time.before.relogin", this.getKerberosBeforeReloginMinTime());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.jitter", this.getKerberosRenewJitter());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.window.factor", this.getKerberosRenewWindowFactor());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.cipher.suites", this.getSslCipherSuites());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.endpoint.identification.algorithm", this.getSslEndpointAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keymanager.algorithm", this.getSslKeymanagerAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.trustmanager.algorithm", this.getSslTrustmanagerAlgorithm());
        return props;
    }

    public Properties createConsumerProperties() {
        Properties props = new Properties();
        KafkaConfiguration.addPropertyIfNotNull(props, "key.deserializer", this.getKeyDeserializer());
        KafkaConfiguration.addPropertyIfNotNull(props, "value.deserializer", this.getValueDeserializer());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.min.bytes", this.getFetchMinBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "heartbeat.interval.ms", this.getHeartbeatIntervalMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.partition.fetch.bytes", this.getMaxPartitionFetchBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "session.timeout.ms", this.getSessionTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.key.password", this.getSslKeyPassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.location", this.getSslKeystoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.password", this.getSslKeystorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.location", this.getSslTruststoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.password", this.getSslTruststorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "auto.offset.reset", this.getAutoOffsetReset());
        KafkaConfiguration.addPropertyIfNotNull(props, "connections.max.idle.ms", this.getConnectionMaxIdleMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "enable.auto.commit", this.isAutoCommitEnable());
        KafkaConfiguration.addPropertyIfNotNull(props, "partition.assignment.strategy", this.getPartitionAssignor());
        KafkaConfiguration.addPropertyIfNotNull(props, "receive.buffer.bytes", this.getReceiveBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "request.timeout.ms", this.getConsumerRequestTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.service.name", this.getSaslKerberosServiceName());
        KafkaConfiguration.addPropertyIfNotNull(props, "security.protocol", this.getSecurityProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.getSendBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.enabled.protocols", this.getSslEnabledProtocols());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.type", this.getSslKeystoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.protocol", this.getSslProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.provider", this.getSslProvider());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.type", this.getSslTruststoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "auto.commit.interval.ms", this.getAutoCommitIntervalMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "check.crcs", this.getCheckCrcs());
        KafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.getClientId());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.max.wait.ms", this.getFetchWaitMaxMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "metadata.max.age.ms", this.getMetadataMaxAgeMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "metric.reporters", this.getMetricReporters());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.num.samples", this.getNoOfMetricsSample());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.sample.window.ms", this.getMetricsSampleWindowMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.ms", this.getReconnectBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "retry.backoff.ms", this.getRetryBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.kinit.cmd", this.getKerberosInitCmd());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.min.time.before.relogin", this.getKerberosBeforeReloginMinTime());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.jitter", this.getKerberosRenewJitter());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.window.factor", this.getKerberosRenewWindowFactor());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.cipher.suites", this.getSslCipherSuites());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.endpoint.identification.algorithm", this.getSslEndpointAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keymanager.algorithm", this.getSslKeymanagerAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.trustmanager.algorithm", this.getSslTrustmanagerAlgorithm());
        return props;
    }

    private static <T> void addPropertyIfNotNull(Properties props, String key, T value) {
        if (value != null) {
            props.put(key, value.toString());
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(String partitioner) {
        this.partitioner = partitioner;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getConsumerStreams() {
        return this.consumerStreams;
    }

    public void setConsumerStreams(int consumerStreams) {
        this.consumerStreams = consumerStreams;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBarrierAwaitTimeoutMs() {
        return this.barrierAwaitTimeoutMs;
    }

    public void setBarrierAwaitTimeoutMs(int barrierAwaitTimeoutMs) {
        this.barrierAwaitTimeoutMs = barrierAwaitTimeoutMs;
    }

    public int getConsumersCount() {
        return this.consumersCount;
    }

    public void setConsumersCount(int consumersCount) {
        this.consumersCount = consumersCount;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public Boolean isAutoCommitEnable() {
        return this.autoCommitEnable;
    }

    public void setAutoCommitEnable(Boolean autoCommitEnable) {
        this.autoCommitEnable = autoCommitEnable;
    }

    public Integer getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public void setAutoCommitIntervalMs(Integer autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
    }

    public Integer getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public void setFetchMinBytes(Integer fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
    }

    public Integer getFetchWaitMaxMs() {
        return this.fetchWaitMaxMs;
    }

    public void setFetchWaitMaxMs(Integer fetchWaitMaxMs) {
        this.fetchWaitMaxMs = fetchWaitMaxMs;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public String getBrokers() {
        return this.brokers;
    }

    public void setBrokers(String brokers) {
        this.brokers = brokers;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(String compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public Integer getRetryBackoffMs() {
        return this.retryBackoffMs;
    }

    public void setRetryBackoffMs(Integer retryBackoffMs) {
        this.retryBackoffMs = retryBackoffMs;
    }

    public Integer getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public void setSendBufferBytes(Integer sendBufferBytes) {
        this.sendBufferBytes = sendBufferBytes;
    }

    public Integer getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(Integer requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public Integer getQueueBufferingMaxMessages() {
        return this.queueBufferingMaxMessages;
    }

    public void setQueueBufferingMaxMessages(Integer queueBufferingMaxMessages) {
        this.queueBufferingMaxMessages = queueBufferingMaxMessages;
    }

    public String getSerializerClass() {
        if (this.serializerClass == null) {
            return "org.apache.kafka.common.serialization.StringSerializer";
        }
        return this.serializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public String getKeySerializerClass() {
        if (this.keySerializerClass == null) {
            return "org.apache.kafka.common.serialization.StringSerializer";
        }
        return this.keySerializerClass;
    }

    public void setKeySerializerClass(String keySerializerClass) {
        this.keySerializerClass = keySerializerClass;
    }

    public String getKerberosInitCmd() {
        return this.kerberosInitCmd;
    }

    public void setKerberosInitCmd(String kerberosInitCmd) {
        this.kerberosInitCmd = kerberosInitCmd;
    }

    public Integer getKerberosBeforeReloginMinTime() {
        return this.kerberosBeforeReloginMinTime;
    }

    public void setKerberosBeforeReloginMinTime(Integer kerberosBeforeReloginMinTime) {
        this.kerberosBeforeReloginMinTime = kerberosBeforeReloginMinTime;
    }

    public Double getKerberosRenewJitter() {
        return this.kerberosRenewJitter;
    }

    public void setKerberosRenewJitter(Double kerberosRenewJitter) {
        this.kerberosRenewJitter = kerberosRenewJitter;
    }

    public Double getKerberosRenewWindowFactor() {
        return this.kerberosRenewWindowFactor;
    }

    public void setKerberosRenewWindowFactor(Double kerberosRenewWindowFactor) {
        this.kerberosRenewWindowFactor = kerberosRenewWindowFactor;
    }

    public String getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public void setSslCipherSuites(String sslCipherSuites) {
        this.sslCipherSuites = sslCipherSuites;
    }

    public String getSslEndpointAlgorithm() {
        return this.sslEndpointAlgorithm;
    }

    public void setSslEndpointAlgorithm(String sslEndpointAlgorithm) {
        this.sslEndpointAlgorithm = sslEndpointAlgorithm;
    }

    public String getSslKeymanagerAlgorithm() {
        return this.sslKeymanagerAlgorithm;
    }

    public void setSslKeymanagerAlgorithm(String sslKeymanagerAlgorithm) {
        this.sslKeymanagerAlgorithm = sslKeymanagerAlgorithm;
    }

    public String getSslTrustmanagerAlgorithm() {
        return this.sslTrustmanagerAlgorithm;
    }

    public void setSslTrustmanagerAlgorithm(String sslTrustmanagerAlgorithm) {
        this.sslTrustmanagerAlgorithm = sslTrustmanagerAlgorithm;
    }

    public String getSslEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public void setSslEnabledProtocols(String sslEnabledProtocols) {
        this.sslEnabledProtocols = sslEnabledProtocols;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSslProvider() {
        return this.sslProvider;
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public String getSslTruststoreType() {
        return this.sslTruststoreType;
    }

    public void setSslTruststoreType(String sslTruststoreType) {
        this.sslTruststoreType = sslTruststoreType;
    }

    public String getSaslKerberosServiceName() {
        return this.saslKerberosServiceName;
    }

    public void setSaslKerberosServiceName(String saslKerberosServiceName) {
        this.saslKerberosServiceName = saslKerberosServiceName;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslKeystoreLocation() {
        return this.sslKeystoreLocation;
    }

    public void setSslKeystoreLocation(String sslKeystoreLocation) {
        this.sslKeystoreLocation = sslKeystoreLocation;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public String getSslTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public void setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public Integer getBufferMemorySize() {
        return this.bufferMemorySize;
    }

    public void setBufferMemorySize(Integer bufferMemorySize) {
        this.bufferMemorySize = bufferMemorySize;
    }

    public Integer getRequestRequiredAcks() {
        return this.requestRequiredAcks;
    }

    public void setRequestRequiredAcks(Integer requestRequiredAcks) {
        this.requestRequiredAcks = requestRequiredAcks;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Integer getProducerBatchSize() {
        return this.producerBatchSize;
    }

    public void setProducerBatchSize(Integer producerBatchSize) {
        this.producerBatchSize = producerBatchSize;
    }

    public Integer getConnectionMaxIdleMs() {
        return this.connectionMaxIdleMs;
    }

    public void setConnectionMaxIdleMs(Integer connectionMaxIdleMs) {
        this.connectionMaxIdleMs = connectionMaxIdleMs;
    }

    public Integer getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(Integer lingerMs) {
        this.lingerMs = lingerMs;
    }

    public Integer getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public void setMaxBlockMs(Integer maxBlockMs) {
        this.maxBlockMs = maxBlockMs;
    }

    public Integer getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(Integer maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public Integer getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public void setReceiveBufferBytes(Integer receiveBufferBytes) {
        this.receiveBufferBytes = receiveBufferBytes;
    }

    public Integer getMaxInFlightRequest() {
        return this.maxInFlightRequest;
    }

    public void setMaxInFlightRequest(Integer maxInFlightRequest) {
        this.maxInFlightRequest = maxInFlightRequest;
    }

    public Integer getMetadataMaxAgeMs() {
        return this.metadataMaxAgeMs;
    }

    public void setMetadataMaxAgeMs(Integer metadataMaxAgeMs) {
        this.metadataMaxAgeMs = metadataMaxAgeMs;
    }

    public String getMetricReporters() {
        return this.metricReporters;
    }

    public void setMetricReporters(String metricReporters) {
        this.metricReporters = metricReporters;
    }

    public Integer getNoOfMetricsSample() {
        return this.noOfMetricsSample;
    }

    public void setNoOfMetricsSample(Integer noOfMetricsSample) {
        this.noOfMetricsSample = noOfMetricsSample;
    }

    public Integer getMetricsSampleWindowMs() {
        return this.metricsSampleWindowMs;
    }

    public void setMetricsSampleWindowMs(Integer metricsSampleWindowMs) {
        this.metricsSampleWindowMs = metricsSampleWindowMs;
    }

    public Integer getReconnectBackoffMs() {
        return this.reconnectBackoffMs;
    }

    public void setReconnectBackoffMs(Integer reconnectBackoffMs) {
        this.reconnectBackoffMs = reconnectBackoffMs;
    }

    public Integer getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setHeartbeatIntervalMs(Integer heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public Integer getMaxPartitionFetchBytes() {
        return this.maxPartitionFetchBytes;
    }

    public void setMaxPartitionFetchBytes(Integer maxPartitionFetchBytes) {
        this.maxPartitionFetchBytes = maxPartitionFetchBytes;
    }

    public Integer getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public void setSessionTimeoutMs(Integer sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public String getPartitionAssignor() {
        return this.partitionAssignor;
    }

    public void setPartitionAssignor(String partitionAssignor) {
        this.partitionAssignor = partitionAssignor;
    }

    public Integer getConsumerRequestTimeoutMs() {
        return this.consumerRequestTimeoutMs;
    }

    public void setConsumerRequestTimeoutMs(Integer consumerRequestTimeoutMs) {
        this.consumerRequestTimeoutMs = consumerRequestTimeoutMs;
    }

    public Boolean getCheckCrcs() {
        return this.checkCrcs;
    }

    public void setCheckCrcs(Boolean checkCrcs) {
        this.checkCrcs = checkCrcs;
    }

    public String getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public void setKeyDeserializer(String keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    public String getValueDeserializer() {
        return this.valueDeserializer;
    }

    public void setValueDeserializer(String valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
    }
}

