/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducer
extends DefaultProducer {
    private org.apache.kafka.clients.producer.KafkaProducer kafkaProducer;
    private final KafkaEndpoint endpoint;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        if (this.endpoint.getBrokers() != null) {
            props.put("bootstrap.servers", this.endpoint.getBrokers());
        }
        return props;
    }

    public org.apache.kafka.clients.producer.KafkaProducer getKafkaProducer() {
        return this.kafkaProducer;
    }

    public void setKafkaProducer(org.apache.kafka.clients.producer.KafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    protected void doStop() throws Exception {
        if (this.kafkaProducer != null) {
            this.kafkaProducer.close();
        }
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        if (this.kafkaProducer == null) {
            this.kafkaProducer = new org.apache.kafka.clients.producer.KafkaProducer(props);
        }
    }

    public void process(Exchange exchange) throws CamelException {
        ProducerRecord record;
        String topic = this.endpoint.getTopic();
        if (!this.endpoint.isBridgeEndpoint()) {
            topic = (String)exchange.getIn().getHeader("kafka.TOPIC", (Object)topic, String.class);
        }
        if (topic == null) {
            throw new CamelExchangeException("No topic key set", exchange);
        }
        Object partitionKey = exchange.getIn().getHeader("kafka.PARTITION_KEY");
        boolean hasPartitionKey = partitionKey != null;
        Object messageKey = exchange.getIn().getHeader("kafka.CONTENT_TYPE");
        boolean hasMessageKey = messageKey != null;
        Object msg = exchange.getIn().getBody();
        if (hasPartitionKey && hasMessageKey) {
            record = new ProducerRecord(topic, new Integer(partitionKey.toString()), messageKey, msg);
        } else if (hasMessageKey) {
            record = new ProducerRecord(topic, messageKey, msg);
        } else {
            this.log.warn("No message key or partition key set");
            record = new ProducerRecord(topic, msg);
        }
        try {
            this.kafkaProducer.send(record).get();
        }
        catch (Exception e) {
            throw new CamelException((Throwable)e);
        }
    }
}

