/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanManager
implements Service {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanManager.class);
    private final InfinispanConfiguration configuration;
    private final CamelContext camelContext;
    private BasicCacheContainer cacheContainer;
    private boolean isManagedCacheContainer;

    public InfinispanManager(InfinispanConfiguration configuration) {
        this(null, configuration);
    }

    public InfinispanManager(CamelContext camelContext, InfinispanConfiguration configuration) {
        this.camelContext = camelContext;
        this.configuration = configuration;
    }

    public void start() throws Exception {
        this.cacheContainer = this.configuration.getCacheContainer();
        if (this.cacheContainer == null) {
            String uri = this.configuration.getConfigurationUri();
            if (uri != null && this.camelContext != null) {
                uri = this.camelContext.resolvePropertyPlaceholders(uri);
            }
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().classLoader(Thread.currentThread().getContextClassLoader());
            if (uri != null) {
                configurationBuilder.withProperties(InfinispanUtil.loadProperties(this.camelContext, uri));
            }
            this.cacheContainer = new RemoteCacheManager(configurationBuilder.addServers(this.configuration.getHost()).build(), true);
            this.isManagedCacheContainer = true;
        }
    }

    public void stop() throws Exception {
        if (this.isManagedCacheContainer) {
            this.cacheContainer.stop();
        }
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    public boolean isCacheContainerEmbedded() {
        return InfinispanUtil.isEmbedded(this.cacheContainer);
    }

    public boolean isCacheContainerRemote() {
        return InfinispanUtil.isRemote(this.cacheContainer);
    }

    public BasicCache<Object, Object> getCache() {
        return this.getCache(this.configuration.getCacheName());
    }

    public BasicCache<Object, Object> getCache(Exchange exchange) {
        return this.getCache((String)exchange.getIn().getHeader("CamelInfinispanCacheName", String.class));
    }

    public BasicCache<Object, Object> getCache(String cacheName) {
        if (cacheName == null) {
            cacheName = this.configuration.getCacheName();
        }
        LOGGER.trace("Cache[{}]", (Object)cacheName);
        DecoratedCache cache = InfinispanUtil.getCache(this.cacheContainer, cacheName);
        if (this.configuration.hasFlags() && InfinispanUtil.isEmbedded(cache)) {
            cache = new DecoratedCache(InfinispanUtil.asAdvanced(cache), this.configuration.getFlags());
        }
        return cache;
    }
}

