/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.camel.CamelContext;
import org.apache.camel.cdi.CdiEventEndpoint;

final class ForwardingObserverMethod<T>
implements ObserverMethod<T> {
    private final AtomicReference<CdiEventEndpoint<T>> observer = new AtomicReference();
    private final Type type;
    private final Set<Annotation> qualifiers;

    ForwardingObserverMethod(Type type, Set<Annotation> qualifiers) {
        this.type = type;
        this.qualifiers = qualifiers;
    }

    void setObserver(CdiEventEndpoint<T> observer) {
        this.observer.set(observer);
    }

    public Class<?> getBeanClass() {
        return CamelContext.class;
    }

    public Type getObservedType() {
        return this.type;
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.qualifiers;
    }

    public Reception getReception() {
        return Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return TransactionPhase.IN_PROGRESS;
    }

    public void notify(T event) {
        if (this.observer.get() != null) {
            this.observer.get().notify(event);
        }
    }
}

