/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final Object lock = new Object();
    private static final ThreadLocal<String> lastError = new ThreadLocal();
    public static final int LAZY = 1;
    public static final int NOW = 2;
    public static final int LOCAL = 4;
    public static final int GLOBAL = 8;
    private final long handle;
    private final String name;
    private final Foreign foreign;

    private static long dlopen(Foreign foreign, String name2, int flags) {
        try {
            return Foreign.dlopen(name2, flags);
        }
        catch (UnsatisfiedLinkError ex) {
            lastError.set(ex.getMessage());
            return 0L;
        }
    }

    public static final Library getDefault() {
        return DefaultLibrary.INSTANCE;
    }

    public static final Library getCachedInstance(String name2, int flags) {
        Library lib;
        if (name2 == null) {
            return Library.getDefault();
        }
        WeakReference<Library> ref = cache.get(name2);
        Library library2 = lib = ref != null ? (Library)ref.get() : null;
        if (lib != null) {
            return lib;
        }
        lib = Library.openLibrary(name2, flags);
        if (lib == null) {
            return null;
        }
        cache.put(name2, new WeakReference<Library>(lib));
        return lib;
    }

    public static final Library openLibrary(String name2, int flags) {
        Foreign foreign;
        long address2;
        if (flags == 0) {
            flags = 5;
        }
        return (address2 = Library.dlopen(foreign = Foreign.getInstance(), name2, flags)) != 0L ? new Library(foreign, name2, address2) : null;
    }

    private Library(Foreign foreign, String name2, long address2) {
        this.foreign = foreign;
        this.name = name2;
        this.handle = address2;
    }

    public final long getSymbolAddress(String name2) {
        try {
            return Foreign.dlsym(this.handle, name2);
        }
        catch (UnsatisfiedLinkError ex) {
            Library library2 = this;
            lastError.set(library2.foreign.dlerror());
            return 0L;
        }
    }

    public static final String getLastError() {
        String error2 = lastError.get();
        return error2 != null ? error2 : "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.handle != 0L) {
                Foreign.dlclose(this.handle);
            }
        }
        finally {
            super.finalize();
        }
    }

    private static final class DefaultLibrary {
        private static final Library INSTANCE = Library.openLibrary(null, 9);

        private DefaultLibrary() {
        }
    }
}

