/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.feed;

import java.util.Date;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedPollingConsumer;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

public abstract class FeedEndpoint
extends DefaultPollingEndpoint {
    @UriPath
    @Metadata(required="true")
    protected String feedUri;
    @UriParam(defaultValue="true")
    protected boolean splitEntries = true;
    @UriParam
    protected Date lastUpdate;
    @UriParam(defaultValue="true")
    protected boolean filter = true;
    @UriParam(defaultValue="true")
    private boolean feedHeader = true;
    @UriParam
    private boolean sortEntries;
    @UriParam(defaultValue="true")
    private boolean throttleEntries = true;
    @UriParam
    private String username;
    @UriParam
    private String password;

    public FeedEndpoint() {
    }

    public FeedEndpoint(String endpointUri, FeedComponent component, String feedUri) {
        super(endpointUri, (Component)component);
        this.feedUri = feedUri;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("FeedProducer is not implemented");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.feedUri, (String)"feedUri");
        FeedPollingConsumer answer = this.isSplitEntries() ? this.createEntryPollingConsumer(this, processor, this.filter, this.lastUpdate, this.throttleEntries) : this.createPollingConsumer(this, processor);
        answer.setDelay(60000L);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected abstract FeedPollingConsumer createPollingConsumer(FeedEndpoint var1, Processor var2) throws Exception;

    protected abstract FeedPollingConsumer createEntryPollingConsumer(FeedEndpoint var1, Processor var2, boolean var3, Date var4, boolean var5) throws Exception;

    protected Exchange createExchangeWithFeedHeader(Object feed, String header) {
        Exchange exchange = this.createExchange();
        if (this.isFeedHeader()) {
            exchange.getIn().setHeader(header, feed);
        }
        return exchange;
    }

    public abstract Exchange createExchange(Object var1);

    public abstract Exchange createExchange(Object var1, Object var2);

    protected String createEndpointUri() {
        return "atom:" + this.feedUri;
    }

    public String getEndpointKey() {
        return this.getEndpointUri();
    }

    public String getFeedUri() {
        return this.feedUri;
    }

    public void setFeedUri(String feedUri) {
        this.feedUri = feedUri;
    }

    public boolean isSplitEntries() {
        return this.splitEntries;
    }

    public void setSplitEntries(boolean splitEntries) {
        this.splitEntries = splitEntries;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public void setFeedHeader(boolean feedHeader) {
        this.feedHeader = feedHeader;
    }

    public boolean isFeedHeader() {
        return this.feedHeader;
    }

    public void setSortEntries(boolean sortEntries) {
        this.sortEntries = sortEntries;
    }

    public boolean isSortEntries() {
        return this.sortEntries;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public void setThrottleEntries(boolean throttleEntries) {
        this.throttleEntries = throttleEntries;
    }

    public boolean isThrottleEntries() {
        return this.throttleEntries;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

