/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Holder;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.util.CxfUtils;
import org.apache.camel.component.cxf.util.ReaderInputStream;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefaultCxfBinding
implements CxfBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCxfBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public void populateCxfRequestFromExchange(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange, Map<String, Object> requestContext) {
        Map camelHeaders = camelExchange.getIn().getHeaders();
        this.extractInvocationContextFromCamel(camelExchange, camelHeaders, requestContext, "RequestContext");
        this.propagateHeadersFromCamelToCxf(camelExchange, camelHeaders, cxfExchange, requestContext);
        String overrideAddress = (String)camelExchange.getIn().getHeader("CamelDestinationOverrideUrl", String.class);
        if (overrideAddress != null) {
            LOG.trace("Client address is overridden by header '{}' to value '{}'", (Object)"CamelDestinationOverrideUrl", (Object)overrideAddress);
            requestContext.put(org.apache.cxf.message.Message.ENDPOINT_ADDRESS, overrideAddress);
        }
        HashSet<AttachmentImpl> attachments = null;
        boolean isXop = Boolean.valueOf((String)camelExchange.getProperty("mtom-enabled", String.class));
        DataFormat dataFormat = (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class));
        if (!DataFormat.CXF_MESSAGE.equals((Object)dataFormat)) {
            for (Map.Entry entry : camelExchange.getIn().getAttachments().entrySet()) {
                if (attachments == null) {
                    attachments = new HashSet<AttachmentImpl>();
                }
                AttachmentImpl attachment = new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue());
                attachment.setXOP(isXop);
                attachments.add(attachment);
            }
        }
        if (attachments != null) {
            requestContext.put("CamelAttachments", attachments);
        }
    }

    @Override
    public void populateExchangeFromCxfResponse(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> responseContext) {
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        if (cxfMessage == null) {
            return;
        }
        LOG.trace("Populate exchange from CXF response message: {}", (Object)cxfMessage);
        camelExchange.getOut().getHeaders().putAll(camelExchange.getIn().getHeaders());
        camelExchange.getOut().setBody(DefaultCxfBinding.getContentFromCxf(cxfMessage, (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class))));
        if (responseContext != null && responseContext.size() > 0 && !this.headerFilterStrategy.applyFilterToExternalHeaders("ResponseContext", responseContext, camelExchange)) {
            camelExchange.getOut().setHeader("ResponseContext", responseContext);
            LOG.trace("Set header = {} value = {}", (Object)"ResponseContext", responseContext);
        }
        this.propagateHeadersFromCxfToCamel(cxfMessage, camelExchange.getOut(), camelExchange);
        DataFormat dataFormat = (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class));
        boolean isXop = Boolean.valueOf((String)camelExchange.getProperty("mtom-enabled", String.class));
        if (cxfMessage.getAttachments() != null) {
            for (Attachment attachment : cxfMessage.getAttachments()) {
                camelExchange.getOut().addAttachment(attachment.getId(), attachment.getDataHandler());
            }
        }
    }

    @Override
    public void populateExchangeFromCxfRequest(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) {
        Method method = null;
        QName operationName = null;
        ExchangePattern mep = ExchangePattern.InOut;
        BindingOperationInfo boi = (BindingOperationInfo)camelExchange.getProperty(BindingOperationInfo.class.getName(), BindingOperationInfo.class);
        if (boi != null) {
            MethodDispatcher md;
            Service service = (Service)cxfExchange.get(Service.class);
            if (service != null && (md = (MethodDispatcher)service.get((Object)MethodDispatcher.class.getName())) != null) {
                method = md.getMethod(boi);
            }
            if (boi.getOperationInfo().isOneWay()) {
                mep = ExchangePattern.InOnly;
            }
            operationName = boi.getName();
        }
        if (operationName != null) {
            camelExchange.getIn().setHeader("operationNamespace", (Object)boi.getName().getNamespaceURI());
            camelExchange.getIn().setHeader("operationName", (Object)boi.getName().getLocalPart());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set IN header: {}={}", (Object)"operationNamespace", (Object)boi.getName().getNamespaceURI());
                LOG.trace("Set IN header: {}={}", (Object)"operationName", (Object)boi.getName().getLocalPart());
            }
        } else if (method != null) {
            camelExchange.getIn().setHeader("operationName", (Object)method.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set IN header: {}={}", (Object)"operationName", (Object)method.getName());
            }
        }
        camelExchange.setPattern(mep);
        LOG.trace("Set exchange MEP: {}", (Object)mep);
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        this.propagateHeadersFromCxfToCamel(cxfMessage, camelExchange.getIn(), camelExchange);
        SecurityContext securityContext = (SecurityContext)cxfMessage.get(SecurityContext.class);
        if (securityContext instanceof LoginSecurityContext && ((LoginSecurityContext)securityContext).getSubject() != null) {
            camelExchange.getIn().getHeaders().put("CamelAuthentication", ((LoginSecurityContext)securityContext).getSubject());
        } else if (securityContext != null && securityContext.getUserPrincipal() != null) {
            Subject subject = new Subject();
            subject.getPrincipals().add(securityContext.getUserPrincipal());
            camelExchange.getIn().getHeaders().put("CamelAuthentication", subject);
        }
        Object value = cxfMessage.get((Object)"RequestContext");
        if (value != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("RequestContext", value, camelExchange)) {
            camelExchange.getIn().setHeader("RequestContext", value);
            LOG.trace("Populate context from CXF message {} value={}", (Object)"RequestContext", value);
        }
        this.setCharsetWithContentType(camelExchange);
        Object body = DefaultCxfBinding.getContentFromCxf(cxfMessage, (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class)));
        if (body != null) {
            camelExchange.getIn().setBody(body);
        }
        if (cxfMessage.getAttachments() != null && !((DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class))).equals((Object)DataFormat.POJO)) {
            for (Attachment attachment : cxfMessage.getAttachments()) {
                camelExchange.getIn().addAttachment(attachment.getId(), attachment.getDataHandler());
            }
        }
    }

    @Override
    public void populateCxfResponseFromExchange(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) {
        BindingOperationInfo boi;
        Message response;
        if (cxfExchange.isOneWay()) {
            return;
        }
        HashMap<String, Object> responseContext = new HashMap<String, Object>();
        if (camelExchange.getPattern().isOutCapable()) {
            if (camelExchange.hasOut()) {
                response = camelExchange.getOut();
                LOG.trace("Get the response from the out message");
            } else {
                response = camelExchange.getIn();
                LOG.trace("Get the response from the in message as a fallback");
            }
        } else {
            response = camelExchange.getIn();
            LOG.trace("Get the response from the in message");
        }
        Map camelHeaders = response.getHeaders();
        this.extractInvocationContextFromCamel(camelExchange, camelHeaders, responseContext, "ResponseContext");
        this.propagateHeadersFromCamelToCxf(camelExchange, camelHeaders, cxfExchange, responseContext);
        Endpoint ep = (Endpoint)cxfExchange.get(Endpoint.class);
        org.apache.cxf.message.Message outMessage = ep.getBinding().createMessage();
        cxfExchange.setOutMessage(outMessage);
        DataFormat dataFormat = (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class));
        responseContext.remove("org.apache.cxf.client");
        outMessage.putAll(responseContext);
        outMessage.put((Object)"ResponseContext", responseContext);
        LOG.trace("Set out response context = {}", responseContext);
        Object outBody = DefaultCxfBinding.getBodyFromCamel(response, dataFormat);
        if (outBody != null) {
            if (dataFormat == DataFormat.PAYLOAD) {
                CxfPayload payload = (CxfPayload)outBody;
                outMessage.setContent(List.class, (Object)this.getResponsePayloadList(cxfExchange, payload.getBodySources()));
                outMessage.put((Object)Header.HEADER_LIST, payload.getHeaders());
            } else {
                if (responseContext.get(Header.HEADER_LIST) != null) {
                    outMessage.put((Object)Header.HEADER_LIST, responseContext.get(Header.HEADER_LIST));
                }
                MessageContentsList resList = null;
                resList = outBody instanceof List ? new MessageContentsList((List)outBody) : (outBody.getClass().isArray() ? new MessageContentsList((Object[])outBody) : new MessageContentsList(new Object[]{outBody}));
                if (resList != null) {
                    outMessage.setContent(List.class, (Object)resList);
                    LOG.trace("Set Out CXF message content = {}", (Object)resList);
                }
            }
        } else if (!cxfExchange.isOneWay() && cxfExchange.getInMessage() != null && MessageUtils.isTrue((Object)cxfExchange.getInMessage().getContextualProperty("jaxws.provider.interpretNullAsOneway"))) {
            DefaultCxfBinding.changeToOneway(cxfExchange);
            return;
        }
        HashSet<AttachmentImpl> attachments = null;
        boolean isXop = Boolean.valueOf((String)camelExchange.getProperty("mtom-enabled", String.class));
        for (Map.Entry entry : camelExchange.getOut().getAttachments().entrySet()) {
            if (attachments == null) {
                attachments = new HashSet<AttachmentImpl>();
            }
            AttachmentImpl attachment = new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue());
            attachment.setXOP(isXop);
            attachments.add(attachment);
        }
        if (attachments != null) {
            outMessage.setAttachments(attachments);
        }
        if ((boi = (BindingOperationInfo)cxfExchange.get(BindingOperationInfo.class)) != null) {
            cxfExchange.put(BindingMessageInfo.class, (Object)boi.getOutput());
        }
    }

    protected void setCharsetWithContentType(Exchange camelExchange) {
        String charset;
        String normalizedEncoding;
        String contentTypeHeader = ExchangeHelper.getContentType((Exchange)camelExchange);
        if (contentTypeHeader != null && (normalizedEncoding = HttpHeaderHelper.mapCharset((String)(charset = HttpHeaderHelper.findCharset((String)contentTypeHeader)), (String)Charset.forName("UTF-8").name())) != null) {
            camelExchange.setProperty("CamelCharsetName", (Object)normalizedEncoding);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    protected MessageContentsList getResponsePayloadList(org.apache.cxf.message.Exchange exchange, List<Source> elements) {
        BindingOperationInfo boi = exchange.getBindingOperationInfo();
        if (boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
            exchange.put(BindingOperationInfo.class, (Object)boi);
        }
        MessageContentsList answer = new MessageContentsList();
        int i = 0;
        if (boi.getOutput() != null) {
            for (MessagePartInfo partInfo : boi.getOutput().getMessageParts()) {
                if (elements == null || elements.size() <= i) continue;
                answer.put(partInfo, (Object)elements.get(i++));
            }
        }
        return answer;
    }

    protected void extractInvocationContextFromCamel(Exchange camelExchange, Map<String, Object> camelHeaders, Map<String, Object> cxfContext, String contextKey) {
        Map context = (Map)camelHeaders.get(contextKey);
        if (context != null) {
            cxfContext.putAll(context);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Propagate {} from header context = {}", (Object)contextKey, (Object)(context instanceof WrappedMessageContext ? ((WrappedMessageContext)context).getWrappedMap() : context));
            }
        }
        if ((context = (Map)camelExchange.getProperty(contextKey)) != null) {
            cxfContext.putAll(context);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Propagate {} from exchange property context = {}", (Object)contextKey, (Object)(context instanceof WrappedMessageContext ? ((WrappedMessageContext)context).getWrappedMap() : context));
            }
        }
        if (camelExchange.getProperties() != null) {
            cxfContext.putAll(camelExchange.getProperties());
        }
        camelExchange.setProperty(contextKey, cxfContext);
    }

    protected void propagateHeadersFromCxfToCamel(org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange exchange) {
        String soapAction;
        String key;
        Object value;
        Map cxfHeaders = CastUtils.cast((Map)((Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        Map camelHeaders = camelMessage.getHeaders();
        camelHeaders.put("CamelCxfMessage", cxfMessage);
        CxfUtils.copyHttpHeadersFromCxfToCamel(cxfMessage, camelMessage);
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                Object evalue;
                if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                if ("Content-Type".compareToIgnoreCase((String)entry.getKey()) == 0 && ((List)entry.getValue()).get(0) != null && ((String)((List)entry.getValue()).get(0)).startsWith("multipart/related")) {
                    DataFormat dataFormat = (DataFormat)((Object)exchange.getProperty("CamelCXFDataFormat", DataFormat.class));
                    if (dataFormat.equals((Object)DataFormat.RAW)) {
                        camelHeaders.put(entry.getKey(), this.getContentTypeString((List)entry.getValue()));
                        continue;
                    }
                    String contentType = this.replaceMultiPartContentType((String)((List)entry.getValue()).get(0));
                    LOG.trace("Find the multi-part Conent-Type, and replace it with {}", (Object)contentType);
                    camelHeaders.put(entry.getKey(), contentType);
                    continue;
                }
                LOG.trace("Populate header from CXF header={} value={}", entry.getKey(), entry.getValue());
                List values = (List)entry.getValue();
                if (values.size() > 1) {
                    if (((Boolean)exchange.getProperty("CamelCxfProtocolHeadersMerged", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
                        StringBuilder sb = new StringBuilder();
                        Iterator it = values.iterator();
                        while (it.hasNext()) {
                            sb.append((String)it.next());
                            if (!it.hasNext()) continue;
                            sb.append(',').append(' ');
                        }
                        evalue = sb.toString();
                    } else {
                        evalue = values;
                    }
                } else {
                    evalue = values.size() == 1 ? (Object)values.get(0) : null;
                }
                if (evalue == null) continue;
                camelHeaders.put(entry.getKey(), evalue);
            }
        }
        if ((value = cxfMessage.get((Object)(key = Header.HEADER_LIST))) != null) {
            if (!this.headerFilterStrategy.applyFilterToExternalHeaders(key, value, exchange)) {
                camelHeaders.put(key, value);
                LOG.trace("Populate header from CXF header={} value={}", (Object)key, value);
            } else {
                ((List)value).clear();
            }
        }
        if (ObjectHelper.isEmpty((Object)(soapAction = (String)camelHeaders.get("SOAPAction"))) || "\"\"".equals(soapAction)) {
            camelHeaders.remove("SOAPAction");
        }
        if ((soapAction = (String)cxfMessage.get((Object)"SOAPAction")) != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("SOAPAction", (Object)soapAction, exchange)) {
            camelHeaders.put("SOAPAction", soapAction);
            LOG.trace("Populate header from CXF header={} value={}", (Object)"SOAPAction", (Object)soapAction);
        }
    }

    protected String replaceMultiPartContentType(String contentType) {
        String[] parts;
        String result = "";
        for (String part : parts = contentType.split(";")) {
            if (!(part = part.trim()).startsWith("type=")) continue;
            if ((part = part.substring(5).trim()).charAt(0) == '\"') {
                result = part.substring(1, part.length() - 1);
                break;
            }
            result = part.substring(5);
            break;
        }
        return result;
    }

    protected String getContentTypeString(List<String> values) {
        String result = "";
        for (String value : values) {
            if (result.length() == 0) {
                result = value;
                continue;
            }
            result = result + "; " + value;
        }
        return result;
    }

    protected void propagateHeadersFromCamelToCxf(Exchange camelExchange, Map<String, Object> camelHeaders, org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> cxfContext) {
        Map headers;
        Map h;
        TreeMap<String, List> transportHeaders = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        if (camelExchange != null && (h = CastUtils.cast((Map)((Map)camelExchange.getProperty(org.apache.cxf.message.Message.PROTOCOL_HEADERS)))) != null) {
            transportHeaders.putAll(h);
        }
        if ((headers = CastUtils.cast((Map)((Map)camelHeaders.get(org.apache.cxf.message.Message.PROTOCOL_HEADERS)))) != null) {
            transportHeaders.putAll(headers);
        }
        DataFormat dataFormat = (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class));
        for (Map.Entry<String, Object> entry : camelHeaders.entrySet()) {
            ArrayList<String> listValue;
            if (org.apache.cxf.message.Message.RESPONSE_CODE.equals(entry.getKey()) || "CamelHttpResponseCode".equals(entry.getKey())) {
                LOG.debug("Propagate to CXF header: {} value: {}", (Object)org.apache.cxf.message.Message.RESPONSE_CODE, entry.getValue());
                cxfContext.put(org.apache.cxf.message.Message.RESPONSE_CODE, entry.getValue());
                continue;
            }
            if ("Content-Type".equalsIgnoreCase(entry.getKey()) && dataFormat.equals((Object)DataFormat.RAW)) {
                LOG.debug("Propagate to CXF header: {} value: {}", (Object)"Content-Type", entry.getValue());
                cxfContext.put("Content-Type", entry.getValue().toString());
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("User-Agent")) {
                listValue = new ArrayList<String>();
                listValue.add(entry.getValue().toString());
                transportHeaders.put("User-Agent", listValue);
            }
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), camelExchange)) continue;
            LOG.debug("Propagate to CXF header: {} value: {}", (Object)entry.getKey(), entry.getValue());
            if (Header.HEADER_LIST.equals(entry.getKey())) {
                List headerList = (List)entry.getValue();
                for (Header header : headerList) {
                    header.setDirection(Header.Direction.DIRECTION_OUT);
                    LOG.trace("Propagate SOAP/protocol header: {} : {}", (Object)header.getName(), header.getObject());
                }
                cxfContext.put(entry.getKey(), headerList);
                continue;
            }
            if (!ObjectHelper.isNotEmpty((Object)entry.getValue())) continue;
            if (entry.getValue() instanceof List) {
                transportHeaders.put(entry.getKey(), (List)entry.getValue());
                continue;
            }
            listValue = new ArrayList();
            listValue.add(entry.getValue().toString());
            transportHeaders.put(entry.getKey(), listValue);
        }
        if (transportHeaders.size() > 0) {
            cxfContext.put(org.apache.cxf.message.Message.PROTOCOL_HEADERS, transportHeaders);
        } else {
            cxfContext.remove(org.apache.cxf.message.Message.PROTOCOL_HEADERS);
        }
    }

    protected static Object getContentFromCxf(org.apache.cxf.message.Message message, DataFormat dataFormat) {
        Set contentFormats = message.getContentFormats();
        Object answer = null;
        if (contentFormats != null) {
            if (LOG.isTraceEnabled()) {
                for (Class contentFormat : contentFormats) {
                    LOG.trace("Content format={} value={}", (Object)contentFormat, message.getContent(contentFormat));
                }
            }
            if (dataFormat == DataFormat.POJO) {
                answer = message.getContent(List.class);
                if (answer == null && (answer = message.getContent(Object.class)) != null) {
                    answer = new MessageContentsList(new Object[]{answer});
                }
            } else if (dataFormat == DataFormat.PAYLOAD) {
                List headers = CastUtils.cast((List)((List)message.get((Object)Header.HEADER_LIST)));
                HashMap<String, String> nsMap = new HashMap<String, String>();
                answer = new CxfPayload(headers, DefaultCxfBinding.getPayloadBodyElements(message, nsMap), nsMap);
            } else if (dataFormat.dealias() == DataFormat.RAW) {
                answer = message.getContent(InputStream.class);
                if (answer == null && (answer = message.getContent(Reader.class)) != null) {
                    answer = new ReaderInputStream((Reader)answer);
                }
            } else if (dataFormat.dealias() == DataFormat.CXF_MESSAGE && message.getContent(List.class) != null) {
                answer = ((List)message.getContent(List.class)).get(0);
            }
            LOG.trace("Extracted body from CXF message = {}", answer);
        }
        return answer;
    }

    protected static void addNamespace(Element element, Map<String, String> nsMap) {
        for (String ns : nsMap.keySet()) {
            if ("xmlns".equals(ns)) {
                if (!ObjectHelper.isEmpty((Object)element.getAttribute("xmlns"))) continue;
                element.setAttribute(ns, nsMap.get(ns));
                continue;
            }
            if (!ObjectHelper.isEmpty((Object)element.getAttribute("xmlns:" + ns))) continue;
            element.setAttribute("xmlns:" + ns, nsMap.get(ns));
        }
    }

    protected static List<Source> getPayloadBodyElements(org.apache.cxf.message.Message message, Map<String, String> nsMap) {
        Map bodyNC = CastUtils.cast((Map)((Map)message.get((Object)"soap.body.ns.context")));
        if (bodyNC != null) {
            nsMap.putAll(bodyNC);
        } else {
            Document soapEnv = (Document)message.getContent(Node.class);
            if (soapEnv != null) {
                NamedNodeMap attrs = soapEnv.getFirstChild().getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node node = attrs.item(i);
                    if (node.getNodeValue().equals("http://schemas.xmlsoap.org/soap/envelope/") || node.getNodeValue().equals("http://www.w3.org/2003/05/soap-envelope")) continue;
                    nsMap.put(node.getLocalName(), node.getNodeValue());
                }
            }
        }
        MessageContentsList inObjects = MessageContentsList.getContentsList((org.apache.cxf.message.Message)message);
        if (inObjects == null) {
            return new ArrayList<Source>(0);
        }
        org.apache.cxf.message.Exchange exchange = message.getExchange();
        BindingOperationInfo boi = exchange.getBindingOperationInfo();
        OperationInfo op = boi.getOperationInfo();
        if (boi.isUnwrapped()) {
            op = boi.getWrappedOperation().getOperationInfo();
        }
        List partInfos = null;
        boolean client = Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
        partInfos = client ? op.getOutput().getMessageParts() : op.getInput().getMessageParts();
        ArrayList<Source> answer = new ArrayList<Source>();
        for (MessagePartInfo partInfo : partInfos) {
            if (!inObjects.hasValue(partInfo)) continue;
            Object part = inObjects.get(partInfo);
            if (part instanceof Holder) {
                part = ((Holder)part).value;
            }
            if (part instanceof Source) {
                Element element = null;
                if (part instanceof DOMSource) {
                    element = DefaultCxfBinding.getFirstElement(((DOMSource)part).getNode());
                }
                if (element != null) {
                    DefaultCxfBinding.addNamespace(element, nsMap);
                    answer.add(new DOMSource(element));
                } else {
                    answer.add((Source)part);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Extract body element {}", (Object)(element == null ? "null" : DefaultCxfBinding.getXMLString(element)));
                continue;
            }
            if (part instanceof Element) {
                DefaultCxfBinding.addNamespace((Element)part, nsMap);
                answer.add(new DOMSource((Element)part));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Unhandled part type '{}'", part.getClass());
        }
        return answer;
    }

    private static String getXMLString(Element el) {
        try {
            return StaxUtils.toString((Element)el);
        }
        catch (Throwable throwable) {
            return "unknown content";
        }
    }

    public static Object getBodyFromCamel(Message out, DataFormat dataFormat) {
        Object answer = null;
        if (dataFormat == DataFormat.POJO) {
            answer = out.getBody();
        } else if (dataFormat == DataFormat.PAYLOAD) {
            answer = out.getBody(CxfPayload.class);
        } else if (dataFormat.dealias() == DataFormat.RAW) {
            answer = out.getBody(InputStream.class);
        } else if (dataFormat.dealias() == DataFormat.CXF_MESSAGE) {
            answer = out.getBody();
        }
        return answer;
    }

    private static Element getFirstElement(Node node) {
        if (node.getNodeType() == 1) {
            return (Element)node;
        }
        return DOMUtils.getFirstElement((Node)node);
    }

    @Override
    public void copyJaxWsContext(org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> context) {
        if (cxfExchange.getOutMessage() != null) {
            org.apache.cxf.message.Message outMessage = cxfExchange.getOutMessage();
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (outMessage.get((Object)entry.getKey()) != null) continue;
                outMessage.put((Object)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void extractJaxWsContext(org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> context) {
        org.apache.cxf.message.Message inMessage = cxfExchange.getInMessage();
        for (Map.Entry entry : inMessage.entrySet()) {
            if (!((String)entry.getKey()).startsWith("javax.xml.ws")) continue;
            context.put((String)entry.getKey(), entry.getValue());
        }
    }

    private static void changeToOneway(org.apache.cxf.message.Exchange cxfExchange) {
        cxfExchange.setOneWay(true);
        Object httpresp = cxfExchange.getInMessage().get((Object)"HTTP.RESPONSE");
        if (httpresp != null) {
            try {
                Method m = DefaultCxfBinding.findMethod(httpresp.getClass(), "setStatus", Integer.TYPE);
                if (m != null) {
                    m.invoke(httpresp, 202);
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to set the http ", (Throwable)e);
            }
        }
    }

    public static Method findMethod(Class<?> cls, String name, Class<?> ... params) {
        Method m3;
        if (cls == null) {
            return null;
        }
        for (Class<?> cs : cls.getInterfaces()) {
            Method m2;
            if (!Modifier.isPublic(cs.getModifiers()) || (m2 = DefaultCxfBinding.findMethod(cs, name, params)) == null || !Modifier.isPublic(m2.getModifiers())) continue;
            return m2;
        }
        try {
            m3 = cls.getDeclaredMethod(name, params);
            if (m3 != null && Modifier.isPublic(m3.getModifiers())) {
                return m3;
            }
        }
        catch (Exception m3) {
            // empty catch block
        }
        m3 = DefaultCxfBinding.findMethod(cls.getSuperclass(), name, params);
        if (m3 == null) {
            try {
                m3 = cls.getMethod(name, params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m3;
    }
}

