/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.PathTemplatePredicate;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.PredicateHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.DefaultUndertowHttpBinding;
import org.apache.camel.component.undertow.RestUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowRegistry;
import org.apache.camel.component.undertow.handlers.HttpCamelHandler;
import org.apache.camel.component.undertow.handlers.NotFoundHandler;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowComponent
extends UriEndpointComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowEndpoint.class);
    private UndertowHttpBinding undertowHttpBinding = new DefaultUndertowHttpBinding();
    private final Map<Integer, UndertowRegistry> serversRegistry = new HashMap<Integer, UndertowRegistry>();
    private SSLContextParameters sslContextParameters;

    public UndertowComponent() {
        super(UndertowEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI uriHttpUriAddress = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, parameters);
        Map options = IntrospectionSupport.extractProperties(parameters, (String)"option.");
        UndertowEndpoint endpoint = this.createEndpointInstance(endpointUri, this);
        endpoint.setSslContextParameters(this.sslContextParameters);
        endpoint.setUndertowHttpBinding(this.undertowHttpBinding);
        this.setProperties((Object)endpoint, parameters);
        if (options != null) {
            endpoint.setOptions(options);
        }
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpURI(httpUri);
        return endpoint;
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new UndertowEndpoint(endpointUri.toString(), component);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        boolean cors;
        String contextPath;
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("undertow", true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if ((config.getComponent() == null || config.getComponent().equals("undertow")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (cors = config.isEnableCORS()) {
            map.put("optionsEnabled", "true");
        }
        String query = URISupport.createQueryString(map);
        String url = api ? "undertow:%s://%s:%s/%s?matchOnUriPrefix=true&httpMethodRestrict=%s" : "undertow:%s://%s:%s/%s?httpMethodRestrict=%s";
        String restrict = verb.toUpperCase(Locale.US);
        if (cors) {
            restrict = restrict + ",OPTIONS";
        }
        url = String.format(url, scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        UndertowEndpoint endpoint = (UndertowEndpoint)camelContext.getEndpoint(url, UndertowEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        if (!map.containsKey("undertowHttpBinding")) {
            endpoint.setUndertowHttpBinding(new RestUndertowHttpBinding());
        }
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        RestConfiguration config = this.getCamelContext().getRestConfiguration("undertow", true);
        if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties((Object)this, config.getComponentProperties());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.serversRegistry.clear();
    }

    public void registerConsumer(UndertowConsumer consumer) {
        int port = consumer.getEndpoint().getHttpURI().getPort();
        if (this.serversRegistry.containsKey(port)) {
            UndertowRegistry undertowRegistry = this.serversRegistry.get(port);
            undertowRegistry.registerConsumer(consumer);
        } else {
            this.serversRegistry.put(port, new UndertowRegistry(consumer, port));
        }
    }

    public void unregisterConsumer(UndertowConsumer consumer) {
        int port = consumer.getEndpoint().getHttpURI().getPort();
        if (this.serversRegistry.containsKey(port)) {
            UndertowRegistry undertowRegistry = this.serversRegistry.get(port);
            undertowRegistry.unregisterConsumer(consumer);
            if (undertowRegistry.isEmpty()) {
                Undertow server = undertowRegistry.getServer();
                if (server != null) {
                    server.stop();
                }
                this.serversRegistry.remove(port);
            } else {
                this.startServer(consumer);
            }
        }
    }

    public void startServer(UndertowConsumer consumer) {
        int port = consumer.getEndpoint().getHttpURI().getPort();
        LOG.info("Starting server on port: {}", (Object)port);
        UndertowRegistry undertowRegistry = this.serversRegistry.get(port);
        if (undertowRegistry.getServer() != null) {
            undertowRegistry.getServer().stop();
        }
        Undertow newServer = this.rebuildServer(undertowRegistry);
        newServer.start();
        undertowRegistry.setServer(newServer);
    }

    protected Undertow rebuildServer(UndertowRegistry registry) {
        Undertow.Builder result = Undertow.builder();
        result = registry.getSslContext() != null ? result.addHttpsListener(registry.getPort(), registry.getHost(), registry.getSslContext()) : result.addHttpListener(registry.getPort(), registry.getHost());
        PathHandler pathHandler = Handlers.path((HttpHandler)new NotFoundHandler());
        HttpCamelHandler handler = new HttpCamelHandler();
        ArrayList<Object> predicates = new ArrayList<Object>();
        for (String key : registry.getConsumersRegistry().keySet()) {
            UndertowConsumer consumer = registry.getConsumersRegistry().get(key);
            UndertowEndpoint endpoint = consumer.getEndpoint();
            String path = endpoint.getHttpURI().getPath();
            if (path.contains("{")) {
                predicates.add(new PathTemplatePredicate(path, ExchangeAttributes.relativePath()));
            } else if (endpoint.getMatchOnUriPrefix().booleanValue()) {
                predicates.add(Predicates.prefix((String)path));
            } else {
                predicates.add(Predicates.path((String)path));
            }
            handler.connectConsumer(consumer);
            LOG.debug("Rebuild for pathHandler: {}", (Object)path);
        }
        Predicate combinedPathPredicate = Predicates.or((Predicate[])predicates.toArray(new Predicate[0]));
        pathHandler.addPrefixPath("/", (HttpHandler)new PredicateHandler(combinedPathPredicate, (HttpHandler)handler, (HttpHandler)new NotFoundHandler()));
        result = result.setHandler((HttpHandler)pathHandler);
        return result.build();
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }
}

