/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Type;

public class ArrayOf
extends Type {
    private final Type type;

    public ArrayOf(Type type) {
        this.type = type;
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        Object[] objs = (Object[])o;
        int size = objs.length;
        buffer.putInt(size);
        for (int i = 0; i < size; ++i) {
            this.type.write(buffer, objs[i]);
        }
    }

    @Override
    public Object read(ByteBuffer buffer) {
        int size = buffer.getInt();
        if (size > buffer.remaining()) {
            throw new SchemaException("Error reading array of size " + size + ", only " + buffer.remaining() + " bytes available");
        }
        Object[] objs = new Object[size];
        for (int i = 0; i < size; ++i) {
            objs[i] = this.type.read(buffer);
        }
        return objs;
    }

    @Override
    public int sizeOf(Object o) {
        Object[] objs = (Object[])o;
        int size = 4;
        for (int i = 0; i < objs.length; ++i) {
            size += this.type.sizeOf(objs[i]);
        }
        return size;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "ARRAY(" + this.type + ")";
    }

    public Object[] validate(Object item) {
        try {
            Object[] array = (Object[])item;
            for (int i = 0; i < array.length; ++i) {
                this.type.validate(array[i]);
            }
            return array;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not an Object[].");
        }
    }
}

