/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.component.twitter.data.EndpointType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

@UriParams
public class TwitterConfiguration {
    @UriPath(description="The kind of endpoint", enums="directmessage,search,streaming/filter,streaming/sample,streaming/user,timeline/home,timeline/mentions,timeline/retweetsofme,timeline/user")
    @Metadata(required="true")
    private String kind;
    @UriParam(label="consumer", defaultValue="direct", enums="polling,direct,event")
    private EndpointType type = EndpointType.DIRECT;
    @UriParam
    private String accessToken;
    @UriParam
    private String accessTokenSecret;
    @UriParam
    private String consumerKey;
    @UriParam
    private String consumerSecret;
    @UriParam
    private String user;
    @UriParam(label="filter")
    private String keywords;
    @UriParam(label="filter")
    private String userIds;
    @UriParam(label="filter", defaultValue="true")
    private boolean filterOld = true;
    @UriParam(label="filter", defaultValue="1")
    private long sinceId = 1L;
    @UriParam(label="filter")
    private String lang;
    @UriParam(label="filter")
    private Integer count;
    @UriParam(label="filter", defaultValue="1")
    private Integer numberOfPages = 1;
    @UriParam(label="proxy")
    private String httpProxyHost;
    @UriParam(label="proxy")
    private String httpProxyUser;
    @UriParam(label="proxy")
    private String httpProxyPassword;
    @UriParam(label="proxy")
    private Integer httpProxyPort;
    @UriParam(label="consumer,advanced")
    private String locations;
    @UriParam(label="consumer,advanced")
    private Double latitude;
    @UriParam(label="consumer,advanced")
    private Double longitude;
    @UriParam(label="consumer,advanced")
    private Double radius;
    @UriParam(label="consumer,advanced", defaultValue="km", enums="km,mi")
    private String distanceMetric;
    private Twitter twitter;
    @UriParam(label="consumer,advanced")
    private TwitterStream twitterStream;

    public void checkComplete() {
        if (this.twitter == null && this.twitterStream == null && (this.consumerKey.isEmpty() || this.consumerSecret.isEmpty() || this.accessToken.isEmpty() || this.accessTokenSecret.isEmpty())) {
            throw new IllegalArgumentException("twitter or twitterStream or all of consumerKey, consumerSecret, accessToken, and accessTokenSecret must be set!");
        }
    }

    public Configuration getConfiguration() {
        this.checkComplete();
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        confBuilder.setOAuthConsumerKey(this.consumerKey);
        confBuilder.setOAuthConsumerSecret(this.consumerSecret);
        confBuilder.setOAuthAccessToken(this.accessToken);
        confBuilder.setOAuthAccessTokenSecret(this.accessTokenSecret);
        if (this.getHttpProxyHost() != null) {
            confBuilder.setHttpProxyHost(this.getHttpProxyHost());
        }
        if (this.getHttpProxyUser() != null) {
            confBuilder.setHttpProxyHost(this.getHttpProxyUser());
        }
        if (this.getHttpProxyPassword() != null) {
            confBuilder.setHttpProxyHost(this.getHttpProxyPassword());
        }
        if (this.httpProxyPort != null) {
            confBuilder.setHttpProxyPort(this.httpProxyPort.intValue());
        }
        return confBuilder.build();
    }

    public Twitter getTwitter() {
        if (this.twitter == null) {
            this.twitter = new TwitterFactory(this.getConfiguration()).getInstance();
        }
        return this.twitter;
    }

    public void setTwitter(Twitter twitter) {
        this.twitter = twitter;
    }

    public TwitterStream getTwitterStream() {
        return this.twitterStream;
    }

    public void setTwitterStream(TwitterStream twitterStream) {
        this.twitterStream = twitterStream;
    }

    public TwitterStream createTwitterStream() {
        if (this.twitterStream == null) {
            this.twitterStream = new TwitterStreamFactory(this.getConfiguration()).getInstance();
        }
        return this.twitterStream;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public EndpointType getType() {
        return this.type;
    }

    public void setType(EndpointType type) {
        this.type = type;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String locations) {
        this.locations = locations;
    }

    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public boolean isFilterOld() {
        return this.filterOld;
    }

    public void setFilterOld(boolean filterOld) {
        this.filterOld = filterOld;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public String getDistanceMetric() {
        return this.distanceMetric;
    }

    public void setDistanceMetric(String distanceMetric) {
        this.distanceMetric = distanceMetric;
    }
}

