/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.lang.reflect.Field;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.KafkaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.CastUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="kafka", title="Kafka", syntax="kafka:brokers", consumerClass=KafkaConsumer.class, label="messaging")
public class KafkaEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaEndpoint.class);
    @UriParam
    private KafkaConfiguration configuration = new KafkaConfiguration();
    @UriParam
    private boolean bridgeEndpoint;

    public KafkaEndpoint() {
    }

    public KafkaEndpoint(String endpointUri, KafkaComponent component) {
        super(endpointUri, (Component)component);
    }

    public KafkaConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(KafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    protected KafkaConfiguration createConfiguration() {
        return new KafkaConfiguration();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KafkaConsumer consumer = new KafkaConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        KafkaProducer producer = this.createProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)producer);
        }
        return producer;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    private void loadParitionerClass(ClassResolver resolver, Properties props) {
        this.replaceWithClass(props, "partitioner.class", resolver, Partitioner.class);
    }

    <T> Class<T> loadClass(Object o, ClassResolver resolver, Class<T> type) {
        if (o == null || o instanceof Class) {
            return CastUtils.cast((Class)((Class)o));
        }
        String name = o.toString();
        Class c = resolver.resolveClass(name, type);
        if (c == null) {
            c = resolver.resolveClass(name, type, ((Object)((Object)this)).getClass().getClassLoader());
        }
        if (c == null) {
            c = resolver.resolveClass(name, type, org.apache.kafka.clients.producer.KafkaProducer.class.getClassLoader());
        }
        return c;
    }

    void replaceWithClass(Properties props, String key, ClassResolver resolver, Class<?> type) {
        Class<?> c = this.loadClass(props.get(key), resolver, type);
        if (c != null) {
            props.put(key, c);
        }
    }

    public void updateClassProperties(Properties props) {
        block6: {
            try {
                if (this.getCamelContext() == null) break block6;
                ClassResolver resolver = this.getCamelContext().getClassResolver();
                this.replaceWithClass(props, "key.serializer", resolver, Serializer.class);
                this.replaceWithClass(props, "value.serializer", resolver, Serializer.class);
                try {
                    Field f = ProducerConfig.class.getDeclaredField("PARTITIONER_CLASS_CONFIG");
                    if (f != null) {
                        this.loadParitionerClass(resolver, props);
                    }
                }
                catch (NoSuchFieldException e) {
                }
                catch (SecurityException securityException) {}
            }
            catch (Throwable t) {
                LOG.debug("Problem loading classes for Serializers", t);
            }
        }
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "KafkaConsumer[" + this.configuration.getTopic() + "]", this.configuration.getConsumerStreams());
    }

    public ExecutorService createProducerExecutor() {
        int core = this.getConfiguration().getWorkerPoolCoreSize();
        int max = this.getConfiguration().getWorkerPoolMaxSize();
        return this.getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, "KafkaProducer[" + this.configuration.getTopic() + "]", core, max);
    }

    public Exchange createKafkaExchange(ConsumerRecord record) {
        Exchange exchange = super.createExchange();
        Message message = exchange.getIn();
        message.setHeader("kafka.EXCHANGE_NAME", (Object)record.partition());
        message.setHeader("kafka.TOPIC", (Object)record.topic());
        message.setHeader("kafka.OFFSET", (Object)record.offset());
        if (record.key() != null) {
            message.setHeader("kafka.CONTENT_TYPE", record.key());
        }
        message.setBody(record.value());
        return exchange;
    }

    protected KafkaProducer createProducer(KafkaEndpoint endpoint) {
        return new KafkaProducer(endpoint);
    }

    public Properties createProducerProperties() {
        return this.configuration.createProducerProperties();
    }

    public void setValueDeserializer(String valueDeserializer) {
        this.configuration.setValueDeserializer(valueDeserializer);
    }

    public void setRequestTimeoutMs(Integer requestTimeoutMs) {
        this.configuration.setRequestTimeoutMs(requestTimeoutMs);
    }

    public void setProducerBatchSize(Integer producerBatchSize) {
        this.configuration.setProducerBatchSize(producerBatchSize);
    }

    public void setRetryBackoffMs(Integer retryBackoffMs) {
        this.configuration.setRetryBackoffMs(retryBackoffMs);
    }

    public void setNoOfMetricsSample(Integer noOfMetricsSample) {
        this.configuration.setNoOfMetricsSample(noOfMetricsSample);
    }

    public String getMetricReporters() {
        return this.configuration.getMetricReporters();
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.configuration.setSslKeystoreType(sslKeystoreType);
    }

    public void setSslCipherSuites(String sslCipherSuites) {
        this.configuration.setSslCipherSuites(sslCipherSuites);
    }

    public void setClientId(String clientId) {
        this.configuration.setClientId(clientId);
    }

    public void setMetricsSampleWindowMs(Integer metricsSampleWindowMs) {
        this.configuration.setMetricsSampleWindowMs(metricsSampleWindowMs);
    }

    public String getKeyDeserializer() {
        return this.configuration.getKeyDeserializer();
    }

    public int getConsumersCount() {
        return this.configuration.getConsumersCount();
    }

    public String getSslKeyPassword() {
        return this.configuration.getSslKeyPassword();
    }

    public void setSendBufferBytes(Integer sendBufferBytes) {
        this.configuration.setSendBufferBytes(sendBufferBytes);
    }

    public Boolean isAutoCommitEnable() {
        return this.configuration.isAutoCommitEnable();
    }

    public Integer getMaxBlockMs() {
        return this.configuration.getMaxBlockMs();
    }

    public String getConsumerId() {
        return this.configuration.getConsumerId();
    }

    public void setSslProtocol(String sslProtocol) {
        this.configuration.setSslProtocol(sslProtocol);
    }

    public void setReceiveBufferBytes(Integer receiveBufferBytes) {
        this.configuration.setReceiveBufferBytes(receiveBufferBytes);
    }

    public Boolean getCheckCrcs() {
        return this.configuration.getCheckCrcs();
    }

    public void setGroupId(String groupId) {
        this.configuration.setGroupId(groupId);
    }

    public String getCompressionCodec() {
        return this.configuration.getCompressionCodec();
    }

    public String getGroupId() {
        return this.configuration.getGroupId();
    }

    public void setSslTruststoreLocation(String sslTruststoreLocation) {
        this.configuration.setSslTruststoreLocation(sslTruststoreLocation);
    }

    public String getKerberosInitCmd() {
        return this.configuration.getKerberosInitCmd();
    }

    public String getAutoOffsetReset() {
        return this.configuration.getAutoOffsetReset();
    }

    public void setAutoCommitEnable(Boolean autoCommitEnable) {
        this.configuration.setAutoCommitEnable(autoCommitEnable);
    }

    public void setSerializerClass(String serializerClass) {
        this.configuration.setSerializerClass(serializerClass);
    }

    public Integer getQueueBufferingMaxMessages() {
        return this.configuration.getQueueBufferingMaxMessages();
    }

    public void setSslEndpointAlgorithm(String sslEndpointAlgorithm) {
        this.configuration.setSslEndpointAlgorithm(sslEndpointAlgorithm);
    }

    public void setRetries(Integer retries) {
        this.configuration.setRetries(retries);
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.configuration.setAutoOffsetReset(autoOffsetReset);
    }

    public Integer getSessionTimeoutMs() {
        return this.configuration.getSessionTimeoutMs();
    }

    public Integer getBufferMemorySize() {
        return this.configuration.getBufferMemorySize();
    }

    public String getKeySerializerClass() {
        return this.configuration.getKeySerializerClass();
    }

    public void setSslProvider(String sslProvider) {
        this.configuration.setSslProvider(sslProvider);
    }

    public void setFetchMinBytes(Integer fetchMinBytes) {
        this.configuration.setFetchMinBytes(fetchMinBytes);
    }

    public Integer getAutoCommitIntervalMs() {
        return this.configuration.getAutoCommitIntervalMs();
    }

    public void setKeySerializerClass(String keySerializerClass) {
        this.configuration.setKeySerializerClass(keySerializerClass);
    }

    public Integer getConnectionMaxIdleMs() {
        return this.configuration.getConnectionMaxIdleMs();
    }

    public Integer getReceiveBufferBytes() {
        return this.configuration.getReceiveBufferBytes();
    }

    public void setBrokers(String brokers) {
        this.configuration.setBrokers(brokers);
    }

    public String getValueDeserializer() {
        return this.configuration.getValueDeserializer();
    }

    public String getPartitioner() {
        return this.configuration.getPartitioner();
    }

    public String getSslTruststoreLocation() {
        return this.configuration.getSslTruststoreLocation();
    }

    public void setBarrierAwaitTimeoutMs(int barrierAwaitTimeoutMs) {
        this.configuration.setBarrierAwaitTimeoutMs(barrierAwaitTimeoutMs);
    }

    public String getSslProvider() {
        return this.configuration.getSslProvider();
    }

    public void setMetricReporters(String metricReporters) {
        this.configuration.setMetricReporters(metricReporters);
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.configuration.setSslTruststorePassword(sslTruststorePassword);
    }

    public void setMaxInFlightRequest(Integer maxInFlightRequest) {
        this.configuration.setMaxInFlightRequest(maxInFlightRequest);
    }

    public String getTopic() {
        return this.configuration.getTopic();
    }

    public int getBarrierAwaitTimeoutMs() {
        return this.configuration.getBarrierAwaitTimeoutMs();
    }

    public Integer getFetchMinBytes() {
        return this.configuration.getFetchMinBytes();
    }

    public Integer getHeartbeatIntervalMs() {
        return this.configuration.getHeartbeatIntervalMs();
    }

    public void setKeyDeserializer(String keyDeserializer) {
        this.configuration.setKeyDeserializer(keyDeserializer);
    }

    public Integer getMaxRequestSize() {
        return this.configuration.getMaxRequestSize();
    }

    public void setMetadataMaxAgeMs(Integer metadataMaxAgeMs) {
        this.configuration.setMetadataMaxAgeMs(metadataMaxAgeMs);
    }

    public String getSslKeystoreType() {
        return this.configuration.getSslKeystoreType();
    }

    public void setKerberosRenewWindowFactor(Double kerberosRenewWindowFactor) {
        this.configuration.setKerberosRenewWindowFactor(kerberosRenewWindowFactor);
    }

    public Integer getKerberosBeforeReloginMinTime() {
        return this.configuration.getKerberosBeforeReloginMinTime();
    }

    public String getSslEnabledProtocols() {
        return this.configuration.getSslEnabledProtocols();
    }

    public Integer getMaxInFlightRequest() {
        return this.configuration.getMaxInFlightRequest();
    }

    public Integer getProducerBatchSize() {
        return this.configuration.getProducerBatchSize();
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.configuration.setSslKeystorePassword(sslKeystorePassword);
    }

    public void setCheckCrcs(Boolean checkCrcs) {
        this.configuration.setCheckCrcs(checkCrcs);
    }

    public int getConsumerStreams() {
        return this.configuration.getConsumerStreams();
    }

    public void setConsumersCount(int consumersCount) {
        this.configuration.setConsumersCount(consumersCount);
    }

    public int getBatchSize() {
        return this.configuration.getBatchSize();
    }

    public void setAutoCommitIntervalMs(Integer autoCommitIntervalMs) {
        this.configuration.setAutoCommitIntervalMs(autoCommitIntervalMs);
    }

    public void setSslTruststoreType(String sslTruststoreType) {
        this.configuration.setSslTruststoreType(sslTruststoreType);
    }

    public Integer getConsumerRequestTimeoutMs() {
        return this.configuration.getConsumerRequestTimeoutMs();
    }

    public String getSslKeystorePassword() {
        return this.configuration.getSslKeystorePassword();
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.configuration.setSslKeyPassword(sslKeyPassword);
    }

    public String getRequestRequiredAcks() {
        return this.configuration.getRequestRequiredAcks();
    }

    public Double getKerberosRenewWindowFactor() {
        return this.configuration.getKerberosRenewWindowFactor();
    }

    public void setKerberosInitCmd(String kerberosInitCmd) {
        this.configuration.setKerberosInitCmd(kerberosInitCmd);
    }

    public Integer getRetryBackoffMs() {
        return this.configuration.getRetryBackoffMs();
    }

    public void setSslTrustmanagerAlgorithm(String sslTrustmanagerAlgorithm) {
        this.configuration.setSslTrustmanagerAlgorithm(sslTrustmanagerAlgorithm);
    }

    public void setConsumerRequestTimeoutMs(Integer consumerRequestTimeoutMs) {
        this.configuration.setConsumerRequestTimeoutMs(consumerRequestTimeoutMs);
    }

    public void setReconnectBackoffMs(Integer reconnectBackoffMs) {
        this.configuration.setReconnectBackoffMs(reconnectBackoffMs);
    }

    public void setKerberosRenewJitter(Double kerberosRenewJitter) {
        this.configuration.setKerberosRenewJitter(kerberosRenewJitter);
    }

    public String getSslKeystoreLocation() {
        return this.configuration.getSslKeystoreLocation();
    }

    public Integer getNoOfMetricsSample() {
        return this.configuration.getNoOfMetricsSample();
    }

    public String getSslKeymanagerAlgorithm() {
        return this.configuration.getSslKeymanagerAlgorithm();
    }

    public void setConsumerId(String consumerId) {
        this.configuration.setConsumerId(consumerId);
    }

    public String getClientId() {
        return this.configuration.getClientId();
    }

    public void setFetchWaitMaxMs(Integer fetchWaitMaxMs) {
        this.configuration.setFetchWaitMaxMs(fetchWaitMaxMs);
    }

    public String getSslCipherSuites() {
        return this.configuration.getSslCipherSuites();
    }

    public void setRequestRequiredAcks(String requestRequiredAcks) {
        this.configuration.setRequestRequiredAcks(requestRequiredAcks);
    }

    public void setConnectionMaxIdleMs(Integer connectionMaxIdleMs) {
        this.configuration.setConnectionMaxIdleMs(connectionMaxIdleMs);
    }

    public String getSslTrustmanagerAlgorithm() {
        return this.configuration.getSslTrustmanagerAlgorithm();
    }

    public String getSslTruststorePassword() {
        return this.configuration.getSslTruststorePassword();
    }

    public void setConsumerStreams(int consumerStreams) {
        this.configuration.setConsumerStreams(consumerStreams);
    }

    public String getSslTruststoreType() {
        return this.configuration.getSslTruststoreType();
    }

    public String getSecurityProtocol() {
        return this.configuration.getSecurityProtocol();
    }

    public void setBufferMemorySize(Integer bufferMemorySize) {
        this.configuration.setBufferMemorySize(bufferMemorySize);
    }

    public void setSaslKerberosServiceName(String saslKerberosServiceName) {
        this.configuration.setSaslKerberosServiceName(saslKerberosServiceName);
    }

    public void setCompressionCodec(String compressionCodec) {
        this.configuration.setCompressionCodec(compressionCodec);
    }

    public void setKerberosBeforeReloginMinTime(Integer kerberosBeforeReloginMinTime) {
        this.configuration.setKerberosBeforeReloginMinTime(kerberosBeforeReloginMinTime);
    }

    public Integer getMetadataMaxAgeMs() {
        return this.configuration.getMetadataMaxAgeMs();
    }

    public String getSerializerClass() {
        return this.configuration.getSerializerClass();
    }

    public void setSslKeymanagerAlgorithm(String sslKeymanagerAlgorithm) {
        this.configuration.setSslKeymanagerAlgorithm(sslKeymanagerAlgorithm);
    }

    public void setMaxRequestSize(Integer maxRequestSize) {
        this.configuration.setMaxRequestSize(maxRequestSize);
    }

    public Double getKerberosRenewJitter() {
        return this.configuration.getKerberosRenewJitter();
    }

    public String getPartitionAssignor() {
        return this.configuration.getPartitionAssignor();
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.configuration.setSecurityProtocol(securityProtocol);
    }

    public void setQueueBufferingMaxMessages(Integer queueBufferingMaxMessages) {
        this.configuration.setQueueBufferingMaxMessages(queueBufferingMaxMessages);
    }

    public String getSaslKerberosServiceName() {
        return this.configuration.getSaslKerberosServiceName();
    }

    public void setBatchSize(int batchSize) {
        this.configuration.setBatchSize(batchSize);
    }

    public Integer getLingerMs() {
        return this.configuration.getLingerMs();
    }

    public Integer getRetries() {
        return this.configuration.getRetries();
    }

    public Integer getMaxPartitionFetchBytes() {
        return this.configuration.getMaxPartitionFetchBytes();
    }

    public String getSslEndpointAlgorithm() {
        return this.configuration.getSslEndpointAlgorithm();
    }

    public Integer getReconnectBackoffMs() {
        return this.configuration.getReconnectBackoffMs();
    }

    public void setLingerMs(Integer lingerMs) {
        this.configuration.setLingerMs(lingerMs);
    }

    public void setPartitionAssignor(String partitionAssignor) {
        this.configuration.setPartitionAssignor(partitionAssignor);
    }

    public Integer getRequestTimeoutMs() {
        return this.configuration.getRequestTimeoutMs();
    }

    public Properties createConsumerProperties() {
        return this.configuration.createConsumerProperties();
    }

    public void setTopic(String topic) {
        this.configuration.setTopic(topic);
    }

    public Integer getFetchWaitMaxMs() {
        return this.configuration.getFetchWaitMaxMs();
    }

    public void setSessionTimeoutMs(Integer sessionTimeoutMs) {
        this.configuration.setSessionTimeoutMs(sessionTimeoutMs);
    }

    public void setSslEnabledProtocols(String sslEnabledProtocols) {
        this.configuration.setSslEnabledProtocols(sslEnabledProtocols);
    }

    public void setHeartbeatIntervalMs(Integer heartbeatIntervalMs) {
        this.configuration.setHeartbeatIntervalMs(heartbeatIntervalMs);
    }

    public void setMaxBlockMs(Integer maxBlockMs) {
        this.configuration.setMaxBlockMs(maxBlockMs);
    }

    public void setSslKeystoreLocation(String sslKeystoreLocation) {
        this.configuration.setSslKeystoreLocation(sslKeystoreLocation);
    }

    public void setMaxPartitionFetchBytes(Integer maxPartitionFetchBytes) {
        this.configuration.setMaxPartitionFetchBytes(maxPartitionFetchBytes);
    }

    public void setPartitioner(String partitioner) {
        this.configuration.setPartitioner(partitioner);
    }

    public String getBrokers() {
        return this.configuration.getBrokers();
    }

    public Integer getMetricsSampleWindowMs() {
        return this.configuration.getMetricsSampleWindowMs();
    }

    public Integer getSendBufferBytes() {
        return this.configuration.getSendBufferBytes();
    }

    public String getSslProtocol() {
        return this.configuration.getSslProtocol();
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.configuration.setWorkerPool(workerPool);
    }

    public void setWorkerPoolMaxSize(Integer workerPoolMaxSize) {
        this.configuration.setWorkerPoolMaxSize(workerPoolMaxSize);
    }

    public Integer getWorkerPoolMaxSize() {
        return this.configuration.getWorkerPoolMaxSize();
    }

    public Integer getWorkerPoolCoreSize() {
        return this.configuration.getWorkerPoolCoreSize();
    }

    public ExecutorService getWorkerPool() {
        return this.configuration.getWorkerPool();
    }

    public void setWorkerPoolCoreSize(Integer workerPoolCoreSize) {
        this.configuration.setWorkerPoolCoreSize(workerPoolCoreSize);
    }
}

