/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class KafkaProducer
extends DefaultAsyncProducer {
    private org.apache.kafka.clients.producer.KafkaProducer kafkaProducer;
    private final KafkaEndpoint endpoint;
    private ExecutorService workerPool;
    private boolean shutdownWorkerPool;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        this.endpoint.updateClassProperties(props);
        if (this.endpoint.getBrokers() != null) {
            props.put("bootstrap.servers", this.endpoint.getBrokers());
        }
        return props;
    }

    public org.apache.kafka.clients.producer.KafkaProducer getKafkaProducer() {
        return this.kafkaProducer;
    }

    public void setKafkaProducer(org.apache.kafka.clients.producer.KafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        if (this.kafkaProducer == null) {
            this.kafkaProducer = new org.apache.kafka.clients.producer.KafkaProducer(props);
        }
        if (!this.endpoint.isSynchronous() && this.workerPool == null) {
            this.workerPool = this.endpoint.createProducerExecutor();
            this.shutdownWorkerPool = true;
        }
    }

    protected void doStop() throws Exception {
        if (this.kafkaProducer != null) {
            this.kafkaProducer.close();
        }
        if (this.shutdownWorkerPool && this.workerPool != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.workerPool);
            this.workerPool = null;
        }
    }

    protected Iterator<ProducerRecord> createRecorder(Exchange exchange) throws CamelException {
        ProducerRecord record;
        String topic = this.endpoint.getTopic();
        if (!this.endpoint.isBridgeEndpoint()) {
            topic = (String)exchange.getIn().getHeader("kafka.TOPIC", (Object)topic, String.class);
        }
        if (topic == null) {
            throw new CamelExchangeException("No topic key set", exchange);
        }
        final Object partitionKey = exchange.getIn().getHeader("kafka.PARTITION_KEY");
        final boolean hasPartitionKey = partitionKey != null;
        final Object messageKey = exchange.getIn().getHeader("kafka.CONTENT_TYPE");
        final boolean hasMessageKey = messageKey != null;
        Object msg = exchange.getIn().getBody();
        Iterator iterator = null;
        if (msg instanceof Iterable) {
            iterator = ((Iterable)msg).iterator();
        } else if (msg instanceof Iterator) {
            iterator = (Iterator)msg;
        }
        if (iterator != null) {
            final Iterator msgList = iterator;
            final String msgTopic = topic;
            return new Iterator<ProducerRecord>(){

                @Override
                public boolean hasNext() {
                    return msgList.hasNext();
                }

                @Override
                public ProducerRecord next() {
                    if (hasPartitionKey && hasMessageKey) {
                        return new ProducerRecord(msgTopic, new Integer(partitionKey.toString()), messageKey, msgList.next());
                    }
                    if (hasMessageKey) {
                        return new ProducerRecord(msgTopic, messageKey, msgList.next());
                    }
                    return new ProducerRecord(msgTopic, msgList.next());
                }

                @Override
                public void remove() {
                    msgList.remove();
                }
            };
        }
        if (hasPartitionKey && hasMessageKey) {
            record = new ProducerRecord(topic, new Integer(partitionKey.toString()), messageKey, msg);
        } else if (hasMessageKey) {
            record = new ProducerRecord(topic, messageKey, msg);
        } else {
            this.log.warn("No message key or partition key set");
            record = new ProducerRecord(topic, msg);
        }
        return Collections.singletonList(record).iterator();
    }

    public void process(Exchange exchange) throws Exception {
        Iterator<ProducerRecord> c = this.createRecorder(exchange);
        LinkedList<Future> futures = new LinkedList<Future>();
        while (c.hasNext()) {
            futures.add(this.kafkaProducer.send(c.next()));
        }
        for (Future f : futures) {
            f.get();
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Iterator<ProducerRecord> c = this.createRecorder(exchange);
            KafkaProducerCallBack cb = new KafkaProducerCallBack(exchange, callback);
            while (c.hasNext()) {
                cb.increment();
                this.kafkaProducer.send(c.next(), (Callback)cb);
            }
            return cb.allSent();
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
            callback.done(true);
            return true;
        }
    }

    private final class KafkaProducerCallBack
    implements Callback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final AtomicInteger count = new AtomicInteger(1);

        KafkaProducerCallBack(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        void increment() {
            this.count.incrementAndGet();
        }

        boolean allSent() {
            if (this.count.decrementAndGet() == 0) {
                this.callback.done(true);
                return true;
            }
            return false;
        }

        public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            if (e != null) {
                this.exchange.setException((Throwable)e);
            }
            if (this.count.decrementAndGet() == 0) {
                KafkaProducer.this.workerPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        KafkaProducerCallBack.this.callback.done(false);
                    }
                });
            }
        }
    }
}

