/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.FromXContentBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class MetaData
implements Iterable<IndexMetaData>,
Diffable<MetaData>,
FromXContentBuilder<MetaData>,
ToXContent {
    public static final MetaData PROTO = MetaData.builder().build();
    public static final String ALL = "_all";
    public static EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static Map<String, Custom> customPrototypes = new HashMap<String, Custom>();
    public static final String SETTING_READ_ONLY = "cluster.blocks.read_only";
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK;
    public static final MetaData EMPTY_META_DATA;
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT;
    public static final String CONTEXT_MODE_GATEWAY;
    private final String clusterUUID;
    private final long version;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final ImmutableOpenMap<String, IndexMetaData> indices;
    private final ImmutableOpenMap<String, IndexTemplateMetaData> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int numberOfShards;
    private final String[] allIndices;
    private final String[] allOpenIndices;
    private final String[] allClosedIndices;
    private final SortedMap<String, AliasOrIndex> aliasAndIndexLookup;
    public static final Set<String> CLUSTER_BYTES_SIZE_SETTINGS;
    public static final Set<String> CLUSTER_TIME_SETTINGS;

    public static void registerPrototype(String type, Custom proto) {
        customPrototypes.put(type, proto);
    }

    @Nullable
    public static <T extends Custom> T lookupPrototype(String type) {
        return (T)customPrototypes.get(type);
    }

    public static <T extends Custom> T lookupPrototypeSafe(String type) {
        Custom proto = customPrototypes.get(type);
        if (proto == null) {
            throw new IllegalArgumentException("No custom metadata prototype registered for type [" + type + "], node like missing plugins");
        }
        return (T)proto;
    }

    MetaData(String clusterUUID, long version, Settings transientSettings, Settings persistentSettings, ImmutableOpenMap<String, IndexMetaData> indices, ImmutableOpenMap<String, IndexTemplateMetaData> templates, ImmutableOpenMap<String, Custom> customs, String[] allIndices, String[] allOpenIndices, String[] allClosedIndices, SortedMap<String, AliasOrIndex> aliasAndIndexLookup) {
        this.clusterUUID = clusterUUID;
        this.version = version;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = Settings.settingsBuilder().put(persistentSettings).put(transientSettings).build();
        this.indices = indices;
        this.customs = customs;
        this.templates = templates;
        int totalNumberOfShards = 0;
        int numberOfShards = 0;
        for (ObjectCursor cursor : indices.values()) {
            totalNumberOfShards += ((IndexMetaData)cursor.value).getTotalNumberOfShards();
            numberOfShards += ((IndexMetaData)cursor.value).getNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.numberOfShards = numberOfShards;
        this.allIndices = allIndices;
        this.allOpenIndices = allOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.aliasAndIndexLookup = aliasAndIndexLookup;
    }

    public long version() {
        return this.version;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public boolean hasAlias(String alias) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)this.getAliasAndIndexLookup().get(alias);
        if (aliasOrIndex != null) {
            return aliasOrIndex.isAlias();
        }
        return false;
    }

    public boolean equalsAliases(MetaData other) {
        for (ObjectCursor cursor : other.indices().values()) {
            IndexMetaData otherIndex = (IndexMetaData)cursor.value;
            IndexMetaData thisIndex = this.indices().get(otherIndex.getIndex());
            if (thisIndex == null) {
                return false;
            }
            if (otherIndex.getAliases().equals(thisIndex.getAliases())) continue;
            return false;
        }
        return true;
    }

    public SortedMap<String, AliasOrIndex> getAliasAndIndexLookup() {
        return this.aliasAndIndexLookup;
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> findAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        boolean matchAllAliases = MetaData.matchAllAliases(aliases);
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = new ArrayList<AliasMetaData>();
            for (ObjectCursor cursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)cursor.value;
                if (!matchAllAliases && !Regex.simpleMatch(aliases, value.alias())) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            CollectionUtil.timSort(filteredValues, (Comparator)new Comparator<AliasMetaData>(){

                @Override
                public int compare(AliasMetaData o1, AliasMetaData o2) {
                    return o1.alias().compareTo(o2.alias());
                }
            });
            mapBuilder.put(index, Collections.unmodifiableList(filteredValues));
        }
        return mapBuilder.build();
    }

    private static boolean matchAllAliases(String[] aliases) {
        for (String alias : aliases) {
            if (!alias.equals(ALL)) continue;
            return true;
        }
        return aliases.length == 0;
    }

    public boolean hasAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return false;
        }
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = new ArrayList<AliasMetaData>();
            for (ObjectCursor cursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)cursor.value;
                if (!Regex.simpleMatch(aliases, value.alias())) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> findMappings(String[] concreteIndices, String[] types) {
        assert (types != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            if (MetaData.isAllTypes(types)) {
                indexMapBuilder.put(index, indexMetaData.getMappings());
                continue;
            }
            ImmutableOpenMap.Builder<Object, Object> filteredMappings = ImmutableOpenMap.builder();
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.getMappings()) {
                if (!Regex.simpleMatch(types, (String)objectObjectCursor.key)) continue;
                filteredMappings.put(objectObjectCursor.key, objectObjectCursor.value);
            }
            if (filteredMappings.isEmpty()) continue;
            indexMapBuilder.put(index, filteredMappings.build());
        }
        return indexMapBuilder.build();
    }

    public ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> findWarmers(String[] concreteIndices, final String[] types, String[] uncheckedWarmers) {
        assert (uncheckedWarmers != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        final String[] warmers = Strings.isAllOrWildcard(uncheckedWarmers) ? Strings.EMPTY_ARRAY : uncheckedWarmers;
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            Collection filteredWarmers;
            IndexMetaData indexMetaData = this.indices.get(index);
            IndexWarmersMetaData indexWarmersMetaData = (IndexWarmersMetaData)indexMetaData.custom("warmers");
            if (indexWarmersMetaData == null || indexWarmersMetaData.entries().isEmpty() || (filteredWarmers = Collections2.filter(indexWarmersMetaData.entries(), (Predicate)new Predicate<IndexWarmersMetaData.Entry>(){

                public boolean apply(IndexWarmersMetaData.Entry warmer) {
                    if (warmers.length != 0 && types.length != 0) {
                        return Regex.simpleMatch(warmers, warmer.name()) && Regex.simpleMatch(types, warmer.types());
                    }
                    if (warmers.length != 0) {
                        return Regex.simpleMatch(warmers, warmer.name());
                    }
                    if (types.length != 0) {
                        return Regex.simpleMatch(types, warmer.types());
                    }
                    return true;
                }
            })).isEmpty()) continue;
            mapBuilder.put(index, Collections.unmodifiableList(new ArrayList(filteredWarmers)));
        }
        return mapBuilder.build();
    }

    public String[] concreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteAllIndices() {
        return this.concreteAllIndices();
    }

    public String[] concreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] concreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        AliasOrIndex result = (AliasOrIndex)this.getAliasAndIndexLookup().get(aliasOrIndex);
        if (result == null || !result.isAlias()) {
            return routing;
        }
        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)result;
        if (result.getIndices().size() > 1) {
            Object[] indexNames = new String[result.getIndices().size()];
            int i = 0;
            for (IndexMetaData indexMetaData : result.getIndices()) {
                indexNames[i++] = indexMetaData.getIndex();
            }
            throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
        }
        AliasMetaData aliasMd = alias.getFirstAliasMetaData();
        if (aliasMd.indexRouting() != null) {
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            routing = aliasMd.indexRouting();
        }
        if (routing != null && routing.indexOf(44) != -1) {
            throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + routing + "] that resolved to several routing values, rejecting operation");
        }
        return routing;
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasConcreteIndex(String index) {
        return this.getAliasAndIndexLookup().containsKey(index);
    }

    public IndexMetaData index(String index) {
        return this.indices.get(index);
    }

    public ImmutableOpenMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableOpenMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfShards() {
        return this.numberOfShards();
    }

    public static boolean isAllTypes(String[] types) {
        return types == null || types.length == 0 || MetaData.isExplicitAllType(types);
    }

    public static boolean isExplicitAllType(String[] types) {
        return types != null && types.length == 1 && ALL.equals(types[0]);
    }

    public boolean routingRequired(String concreteIndex, String type) {
        MappingMetaData mappingMetaData;
        IndexMetaData indexMetaData = this.indices.get(concreteIndex);
        if (indexMetaData != null && (mappingMetaData = indexMetaData.getMappings().get(type)) != null) {
            return mappingMetaData.routing().required();
        }
        return false;
    }

    @Override
    public UnmodifiableIterator<IndexMetaData> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(MetaData metaData1, MetaData metaData2) {
        if (!metaData1.persistentSettings.equals(metaData2.persistentSettings)) {
            return false;
        }
        if (!metaData1.templates.equals(metaData2.templates())) {
            return false;
        }
        int customCount1 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metaData1.customs) {
            if (!customPrototypes.get(objectObjectCursor.key).context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!((Custom)objectObjectCursor.value).equals(metaData2.custom((String)objectObjectCursor.key))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metaData2.customs) {
            if (!customPrototypes.get(objectObjectCursor.key).context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    @Override
    public Diff<MetaData> diff(MetaData previousState) {
        return new MetaDataDiff(previousState, this);
    }

    @Override
    public Diff<MetaData> readDiffFrom(StreamInput in) throws IOException {
        return new MetaDataDiff(in);
    }

    @Override
    public MetaData fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    @Override
    public MetaData readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder();
        builder.version = in.readLong();
        builder.clusterUUID = in.readString();
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetaData.Builder.readFrom(in), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetaData.Builder.readFrom(in));
        }
        int customSize = in.readVInt();
        for (int i2 = 0; i2 < customSize; ++i2) {
            String type = in.readString();
            Custom customIndexMetaData = (Custom)MetaData.lookupPrototypeSafe(type).readFrom(in);
            builder.putCustom(type, customIndexMetaData);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.clusterUUID);
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
        out.writeVInt(this.indices.size());
        for (IndexMetaData indexMetaData : this) {
            indexMetaData.writeTo(out);
        }
        out.writeVInt(this.templates.size());
        for (ObjectObjectCursor<String, Custom> cursor : this.templates.values()) {
            ((IndexTemplateMetaData)cursor.value).writeTo(out);
        }
        out.writeVInt(this.customs.size());
        for (ObjectObjectCursor<String, Custom> cursor : this.customs) {
            out.writeString((String)cursor.key);
            ((Custom)cursor.value).writeTo(out);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetaData metaData) {
        return new Builder(metaData);
    }

    public static MetaData addDefaultUnitsIfNeeded(ESLogger logger, MetaData metaData) {
        Settings.Builder newPersistentSettings = null;
        for (Map.Entry<String, String> ent : metaData.persistentSettings().getAsMap().entrySet()) {
            String settingName = ent.getKey();
            String settingValue = ent.getValue();
            if (CLUSTER_BYTES_SIZE_SETTINGS.contains(settingName)) {
                try {
                    Long.parseLong(settingValue);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                logger.warn("byte-sized cluster setting [{}] with value [{}] is missing units; assuming default units (b) but in future versions this will be a hard error", settingName, settingValue);
                if (newPersistentSettings == null) {
                    newPersistentSettings = Settings.builder();
                    newPersistentSettings.put(metaData.persistentSettings());
                }
                newPersistentSettings.put(settingName, settingValue + "b");
            }
            if (!CLUSTER_TIME_SETTINGS.contains(settingName)) continue;
            try {
                Long.parseLong(settingValue);
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            logger.warn("time cluster setting [{}] with value [{}] is missing units; assuming default units (ms) but in future versions this will be a hard error", settingName, settingValue);
            if (newPersistentSettings == null) {
                newPersistentSettings = Settings.builder();
                newPersistentSettings.put(metaData.persistentSettings());
            }
            newPersistentSettings.put(settingName, settingValue + "ms");
        }
        if (newPersistentSettings != null) {
            return new MetaData(metaData.clusterUUID(), metaData.version(), metaData.transientSettings(), newPersistentSettings.build(), metaData.getIndices(), metaData.getTemplates(), metaData.getCustoms(), metaData.concreteAllIndices(), metaData.concreteAllOpenIndices(), metaData.concreteAllClosedIndices(), metaData.getAliasAndIndexLookup());
        }
        return metaData;
    }

    static {
        MetaData.registerPrototype("repositories", RepositoriesMetaData.PROTO);
        CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
        EMPTY_META_DATA = MetaData.builder().build();
        CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
        CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
        CLUSTER_BYTES_SIZE_SETTINGS = ImmutableSet.of((Object)"indices.store.throttle.max_bytes_per_sec", (Object)"indices.recovery.file_chunk_size", (Object)"indices.recovery.translog_size", (Object)"indices.recovery.max_bytes_per_sec", (Object)"indices.recovery.max_size_per_sec");
        CLUSTER_TIME_SETTINGS = ImmutableSet.of((Object)"indices.ttl.interval", (Object)"indices.recovery.retry_delay_state_sync", (Object)"indices.recovery.retry_delay_network", (Object)"indices.recovery.recovery_activity_timeout", (Object)"indices.recovery.internal_action_timeout", (Object)"indices.recovery.internal_action_long_timeout", (Object[])new String[]{"cluster.routing.allocation.disk.reroute_interval", "cluster.info.update.interval", "cluster.info.update.timeout", "discovery.zen.publish_timeout", "cluster.service.slow_task_logging_threshold"});
    }

    public static class Builder {
        private String clusterUUID;
        private long version;
        private Settings transientSettings = Settings.Builder.EMPTY_SETTINGS;
        private Settings persistentSettings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, IndexMetaData> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetaData> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder() {
            this.clusterUUID = "_na_";
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(MetaData metaData) {
            this.clusterUUID = metaData.clusterUUID;
            this.transientSettings = metaData.transientSettings;
            this.persistentSettings = metaData.persistentSettings;
            this.version = metaData.version;
            this.indices = ImmutableOpenMap.builder(metaData.indices);
            this.templates = ImmutableOpenMap.builder(metaData.templates);
            this.customs = ImmutableOpenMap.builder(metaData.customs);
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            indexMetaDataBuilder.version(indexMetaDataBuilder.version() + 1L);
            IndexMetaData indexMetaData = indexMetaDataBuilder.build();
            this.indices.put(indexMetaData.getIndex(), indexMetaData);
            return this;
        }

        public Builder put(IndexMetaData indexMetaData, boolean incrementVersion) {
            if (this.indices.get(indexMetaData.getIndex()) == indexMetaData) {
                return this;
            }
            if (incrementVersion) {
                indexMetaData = IndexMetaData.builder(indexMetaData).version(indexMetaData.getVersion() + 1L).build();
            }
            this.indices.put(indexMetaData.getIndex(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index) {
            return this.indices.get(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder indices(ImmutableOpenMap<String, IndexMetaData> indices) {
            this.indices.putAll(indices);
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(ImmutableOpenMap<String, IndexTemplateMetaData> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            this.customs.putAll(customs);
            return this;
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = (String[])this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetaData.builder(indexMetaData).settings(Settings.settingsBuilder().put(indexMetaData.getSettings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = (String[])this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetaData.builder(indexMetaData).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals("_na_")) {
                this.clusterUUID = Strings.randomBase64UUID();
            }
            return this;
        }

        public MetaData build() {
            ArrayList<String> allIndicesLst = new ArrayList<String>();
            for (ObjectCursor cursor : this.indices.values()) {
                allIndicesLst.add(((IndexMetaData)cursor.value).getIndex());
            }
            String[] allIndices = allIndicesLst.toArray(new String[allIndicesLst.size()]);
            ArrayList<String> allOpenIndicesLst = new ArrayList<String>();
            ArrayList<String> allClosedIndicesLst = new ArrayList<String>();
            for (ObjectCursor cursor : this.indices.values()) {
                IndexMetaData indexMetaData = (IndexMetaData)cursor.value;
                if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                    allOpenIndicesLst.add(indexMetaData.getIndex());
                    continue;
                }
                if (indexMetaData.getState() != IndexMetaData.State.CLOSE) continue;
                allClosedIndicesLst.add(indexMetaData.getIndex());
            }
            String[] allOpenIndices = allOpenIndicesLst.toArray(new String[allOpenIndicesLst.size()]);
            String[] allClosedIndices = allClosedIndicesLst.toArray(new String[allClosedIndicesLst.size()]);
            SortedMap<String, AliasOrIndex> aliasAndIndexLookup = new TreeMap();
            for (ObjectCursor cursor : this.indices.values()) {
                IndexMetaData indexMetaData = (IndexMetaData)cursor.value;
                aliasAndIndexLookup.put(indexMetaData.getIndex(), new AliasOrIndex.Index(indexMetaData));
                for (ObjectObjectCursor<String, AliasMetaData> aliasCursor : indexMetaData.getAliases()) {
                    AliasMetaData aliasMetaData = (AliasMetaData)aliasCursor.value;
                    AliasOrIndex aliasOrIndex = (AliasOrIndex)aliasAndIndexLookup.get(aliasMetaData.getAlias());
                    if (aliasOrIndex == null) {
                        aliasOrIndex = new AliasOrIndex.Alias(aliasMetaData, indexMetaData);
                        aliasAndIndexLookup.put(aliasMetaData.getAlias(), aliasOrIndex);
                        continue;
                    }
                    if (aliasOrIndex instanceof AliasOrIndex.Alias) {
                        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)aliasOrIndex;
                        alias.addIndex(indexMetaData);
                        continue;
                    }
                    if (aliasOrIndex instanceof AliasOrIndex.Index) {
                        AliasOrIndex.Index index = (AliasOrIndex.Index)aliasOrIndex;
                        throw new IllegalStateException("index and alias names need to be unique, but alias [" + aliasMetaData.getAlias() + "] and index [" + index.getIndex().getIndex() + "] have the same name");
                    }
                    throw new IllegalStateException("unexpected alias [" + aliasMetaData.getAlias() + "][" + aliasOrIndex + "]");
                }
            }
            aliasAndIndexLookup = Collections.unmodifiableSortedMap(aliasAndIndexLookup);
            return new MetaData(this.clusterUUID, this.version, this.transientSettings, this.persistentSettings, this.indices.build(), this.templates.build(), this.customs.build(), allIndices, allOpenIndices, allClosedIndices, aliasAndIndexLookup);
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            XContentContext context = XContentContext.valueOf(params.param(MetaData.CONTEXT_MODE_PARAM, "API"));
            builder.startObject("meta-data");
            builder.field("version", metaData.version());
            builder.field("cluster_uuid", metaData.clusterUUID);
            if (!metaData.persistentSettings().getAsMap().isEmpty()) {
                builder.startObject("settings");
                for (Map.Entry<String, String> entry : metaData.persistentSettings().getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if (context == XContentContext.API && !metaData.transientSettings().getAsMap().isEmpty()) {
                builder.startObject("transient_settings");
                for (Map.Entry<String, String> entry : metaData.transientSettings().getAsMap().entrySet()) {
                    builder.field(entry.getKey(), entry.getValue());
                }
                builder.endObject();
            }
            builder.startObject("templates");
            for (ObjectCursor cursor : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContent((IndexTemplateMetaData)cursor.value, builder, params);
            }
            builder.endObject();
            if (context == XContentContext.API && !metaData.indices().isEmpty()) {
                builder.startObject("indices");
                for (IndexMetaData indexMetaData : metaData) {
                    IndexMetaData.Builder.toXContent(indexMetaData, builder, params);
                }
                builder.endObject();
            }
            for (ObjectCursor cursor : metaData.customs()) {
                Object proto = MetaData.lookupPrototypeSafe((String)cursor.key);
                if (!proto.context().contains((Object)context)) continue;
                builder.startObject((String)cursor.key);
                ((Custom)cursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
                if (token == null) {
                    return builder.build();
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())).build());
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetaData.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetaData.Builder.fromXContent(parser, parser.currentName()));
                        }
                        continue;
                    }
                    Object proto = MetaData.lookupPrototype(currentFieldName);
                    if (proto == null) {
                        parser.skipChildren();
                        continue;
                    }
                    Custom custom = proto.fromXContent(parser);
                    builder.putCustom(custom.type(), custom);
                    continue;
                }
                if (!token.isValue()) continue;
                if ("version".equals(currentFieldName)) {
                    builder.version = parser.longValue();
                    continue;
                }
                if (!"cluster_uuid".equals(currentFieldName) && !"uuid".equals(currentFieldName)) continue;
                builder.clusterUUID = parser.text();
            }
            return builder.build();
        }

        public static MetaData readFrom(StreamInput in) throws IOException {
            return PROTO.readFrom(in);
        }
    }

    private static class MetaDataDiff
    implements Diff<MetaData> {
        private long version;
        private String clusterUUID;
        private Settings transientSettings;
        private Settings persistentSettings;
        private Diff<ImmutableOpenMap<String, IndexMetaData>> indices;
        private Diff<ImmutableOpenMap<String, IndexTemplateMetaData>> templates;
        private Diff<ImmutableOpenMap<String, Custom>> customs;

        public MetaDataDiff(MetaData before, MetaData after) {
            this.clusterUUID = after.clusterUUID;
            this.version = after.version;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            this.indices = DiffableUtils.diff(before.indices, after.indices);
            this.templates = DiffableUtils.diff(before.templates, after.templates);
            this.customs = DiffableUtils.diff(before.customs, after.customs);
        }

        public MetaDataDiff(StreamInput in) throws IOException {
            this.clusterUUID = in.readString();
            this.version = in.readLong();
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.indices = DiffableUtils.readImmutableOpenMapDiff(in, IndexMetaData.PROTO);
            this.templates = DiffableUtils.readImmutableOpenMapDiff(in, IndexTemplateMetaData.PROTO);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, new DiffableUtils.KeyedReader<Custom>(){

                @Override
                public Custom readFrom(StreamInput in, String key) throws IOException {
                    return (Custom)MetaData.lookupPrototypeSafe(key).readFrom(in);
                }

                @Override
                public Diff<Custom> readDiffFrom(StreamInput in, String key) throws IOException {
                    return MetaData.lookupPrototypeSafe(key).readDiffFrom(in);
                }
            });
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterUUID);
            out.writeLong(this.version);
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public MetaData apply(MetaData part) {
            Builder builder = MetaData.builder();
            builder.clusterUUID(this.clusterUUID);
            builder.version(this.version);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.indices(this.indices.apply(part.indices));
            builder.templates(this.templates.apply(part.templates));
            builder.customs(this.customs.apply(part.customs));
            return builder.build();
        }
    }

    public static interface Custom
    extends Diffable<Custom>,
    ToXContent {
        public String type();

        public Custom fromXContent(XContentParser var1) throws IOException;

        public EnumSet<XContentContext> context();
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }
}

