/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
final class CdiCamelRegistry
implements Registry {
    private final Logger logger = LoggerFactory.getLogger(CdiCamelRegistry.class);
    private final BeanManager manager;

    CdiCamelRegistry(BeanManager manager) {
        this.manager = manager;
    }

    public Object lookupByName(String name) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        this.logger.trace("Looking up bean with name [{}]", (Object)name);
        if ("properties".equals(name) && this.findByTypeWithName(PropertiesComponent.class).containsKey("properties")) {
            return BeanManagerHelper.getReferenceByName(this.manager, name, PropertiesComponent.class);
        }
        return BeanManagerHelper.getReferenceByName(this.manager, name, Object.class);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        ObjectHelper.notNull(type, (String)"type");
        this.logger.trace("Looking up bean with name [{}] of type [{}]", (Object)name, type);
        return BeanManagerHelper.getReferenceByName(this.manager, name, type);
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        this.logger.trace("Looking up named beans of type [{}]", type);
        HashMap<String, T> references = new HashMap<String, T>();
        for (Bean bean : this.manager.getBeans(type, new Annotation[]{AnyLiteral.INSTANCE})) {
            if (bean.getName() == null) continue;
            references.put(bean.getName(), BeanManagerHelper.getReference(this.manager, type, bean));
        }
        return references;
    }

    public <T> Set<T> findByType(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        this.logger.trace("Looking up beans of type [{}]", type);
        return BeanManagerHelper.getReferencesByType(this.manager, type, new Annotation[]{AnyLiteral.INSTANCE});
    }

    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }
}

