/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.HttpRequestProperties;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.grants.refresh.RefreshTokenGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HawkAuthorizationScheme;

public final class OAuthClientUtils {
    private OAuthClientUtils() {
    }

    public static URI getAuthorizationURI(String authorizationServiceURI, String clientId, String redirectUri, String state, String scope) {
        UriBuilder ub = OAuthClientUtils.getAuthorizationURIBuilder(authorizationServiceURI, clientId, redirectUri, state, scope);
        if (redirectUri != null) {
            ub.queryParam("redirect_uri", new Object[]{redirectUri});
        }
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub.build(new Object[0]);
    }

    public static UriBuilder getAuthorizationURIBuilder(String authorizationServiceURI, String clientId, String redirectUri, String state, String scope) {
        UriBuilder ub = OAuthClientUtils.getAuthorizationURIBuilder(authorizationServiceURI, clientId, scope);
        if (redirectUri != null) {
            ub.queryParam("redirect_uri", new Object[]{redirectUri});
        }
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub;
    }

    public static UriBuilder getAuthorizationURIBuilder(String authorizationServiceURI, String clientId, String scope) {
        UriBuilder ub = UriBuilder.fromUri((String)authorizationServiceURI);
        if (clientId != null) {
            ub.queryParam("client_id", new Object[]{clientId});
        }
        if (scope != null) {
            ub.queryParam("scope", new Object[]{scope});
        }
        ub.queryParam("response_type", new Object[]{"code"});
        return ub;
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant) throws OAuthServiceException {
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, true);
    }

    public static ClientAccessToken getAccessToken(String accessTokenServiceUri, Consumer consumer, AccessTokenGrant grant, boolean setAuthorizationHeader) throws OAuthServiceException {
        OAuthJSONProvider provider = new OAuthJSONProvider();
        WebClient accessTokenService = WebClient.create((String)accessTokenServiceUri, Collections.singletonList(provider));
        accessTokenService.accept(new String[]{"application/json"});
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, setAuthorizationHeader);
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant, boolean setAuthorizationHeader) {
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, null, setAuthorizationHeader);
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, AccessTokenGrant grant) throws OAuthServiceException {
        return OAuthClientUtils.getAccessToken(accessTokenService, null, grant, null, false);
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, AccessTokenGrant grant, Map<String, String> extraParams) throws OAuthServiceException {
        return OAuthClientUtils.getAccessToken(accessTokenService, null, grant, extraParams, false);
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant, Map<String, String> extraParams, boolean setAuthorizationHeader) throws OAuthServiceException {
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, extraParams, null, setAuthorizationHeader);
    }

    public static ClientAccessToken refreshAccessToken(WebClient accessTokenService, ClientAccessToken at) {
        return OAuthClientUtils.refreshAccessToken(accessTokenService, null, at, null, true);
    }

    public static ClientAccessToken refreshAccessToken(WebClient accessTokenService, Consumer consumer, ClientAccessToken at) {
        return OAuthClientUtils.refreshAccessToken(accessTokenService, consumer, at, null, true);
    }

    public static ClientAccessToken refreshAccessToken(WebClient accessTokenService, Consumer consumer, ClientAccessToken at, String scope, boolean setAuthorizationHeader) throws OAuthServiceException {
        RefreshTokenGrant grant = new RefreshTokenGrant(at.getRefreshToken(), scope);
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, null, at.getTokenType(), setAuthorizationHeader);
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant, Map<String, String> extraParams, String defaultTokenType, boolean setAuthorizationHeader) throws OAuthServiceException {
        Form form = new Form(grant.toMap());
        if (extraParams != null) {
            for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                form.param(entry.getKey(), entry.getValue());
            }
        }
        if (consumer != null) {
            boolean secretAvailable;
            boolean bl = secretAvailable = !StringUtils.isEmpty((String)consumer.getClientSecret());
            if (setAuthorizationHeader && secretAvailable) {
                StringBuilder sb = new StringBuilder();
                sb.append("Basic ");
                try {
                    String data = consumer.getClientId() + ":" + consumer.getClientSecret();
                    sb.append(Base64Utility.encode((byte[])data.getBytes(StandardCharsets.UTF_8)));
                }
                catch (Exception ex) {
                    throw new ProcessingException((Throwable)ex);
                }
                accessTokenService.replaceHeader("Authorization", (Object)sb.toString());
            } else {
                form.param("client_id", consumer.getClientId());
                if (secretAvailable) {
                    form.param("client_secret", consumer.getClientSecret());
                }
            }
        }
        Response response = accessTokenService.form(form);
        Map<String, String> map = null;
        try {
            map = new OAuthJSONProvider().readJSONResponse((InputStream)response.getEntity());
        }
        catch (IOException ex) {
            throw new ResponseProcessingException(response, (Throwable)ex);
        }
        if (200 == response.getStatus()) {
            ClientAccessToken token = OAuthClientUtils.fromMapToClientToken(map, defaultTokenType);
            if (token == null) {
                throw new OAuthServiceException("server_error");
            }
            return token;
        }
        if (response.getStatus() >= 400 && map.containsKey("error")) {
            OAuthError error = new OAuthError(map.get("error"), map.get("error_description"));
            error.setErrorUri(map.get("error_uri"));
            throw new OAuthServiceException(error);
        }
        throw new OAuthServiceException("server_error");
    }

    public static ClientAccessToken fromMapToClientToken(Map<String, String> map) {
        return OAuthClientUtils.fromMapToClientToken(map, null);
    }

    public static ClientAccessToken fromMapToClientToken(Map<String, String> map, String defaultTokenType) {
        if (map.containsKey("access_token")) {
            String tokenType = map.remove("token_type");
            if (tokenType == null) {
                tokenType = defaultTokenType;
            }
            if (tokenType != null) {
                String issuedAtStr;
                String expiresInStr;
                ClientAccessToken token = new ClientAccessToken(tokenType, map.remove("access_token"));
                String refreshToken = map.remove("refresh_token");
                if (refreshToken != null) {
                    token.setRefreshToken(refreshToken);
                }
                if ((expiresInStr = map.remove("expires_in")) != null) {
                    token.setExpiresIn(Long.valueOf(expiresInStr));
                }
                token.setIssuedAt((issuedAtStr = map.remove("issued_at")) != null ? Long.valueOf(issuedAtStr) : System.currentTimeMillis() / 1000L);
                String scope = map.remove("scope");
                if (scope != null) {
                    token.setApprovedScope(scope);
                }
                token.setParameters(map);
                return token;
            }
        }
        return null;
    }

    public static String createAuthorizationHeader(ClientAccessToken accessToken) throws OAuthServiceException {
        return OAuthClientUtils.createAuthorizationHeader(accessToken, null);
    }

    public static String createAuthorizationHeader(ClientAccessToken accessToken, HttpRequestProperties httpProps) throws OAuthServiceException {
        StringBuilder sb = new StringBuilder();
        OAuthClientUtils.appendTokenData(sb, accessToken, httpProps);
        return sb.toString();
    }

    public static void setAuthorizationHeader(WebClient wc, ClientAccessToken accessToken) {
        OAuthClientUtils.setAuthorizationHeader(wc, accessToken, null);
    }

    public static void setAuthorizationHeader(WebClient wc, ClientAccessToken accessToken, String httpVerb) {
        wc.replaceHeader("Authorization", (Object)OAuthClientUtils.createAuthorizationHeader(accessToken, new HttpRequestProperties(wc, httpVerb)));
    }

    private static void appendTokenData(StringBuilder sb, ClientAccessToken token, HttpRequestProperties httpProps) throws OAuthServiceException {
        String tokenType = token.getTokenType().toLowerCase();
        if ("Bearer".equalsIgnoreCase(tokenType)) {
            sb.append("Bearer");
            sb.append(" ");
            sb.append(token.getTokenKey());
        } else if ("hawk".equalsIgnoreCase(tokenType)) {
            if (httpProps == null) {
                throw new IllegalArgumentException("MAC scheme requires HTTP Request properties");
            }
            HawkAuthorizationScheme macAuthData = new HawkAuthorizationScheme(httpProps, token);
            String macAlgo = token.getParameters().get("algorithm");
            String macKey = token.getParameters().get("secret");
            sb.append(macAuthData.toAuthorizationHeader(macAlgo, macKey));
        } else {
            throw new ProcessingException((Throwable)new OAuthServiceException("Unsupported token type"));
        }
    }
}

