/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ws.rs.NotAuthorizedException;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextImpl;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.client.StaticClientTokenContext;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;

public class OAuthInvoker
extends JAXRSInvoker {
    private WebClient accessTokenServiceClient;
    private ClientTokenContextManager clientTokenContextManager;
    private Consumer consumer;

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        Message inMessage = exchange.getInMessage();
        ClientTokenContext tokenContext = (ClientTokenContext)inMessage.getContent(ClientTokenContext.class);
        try {
            if (tokenContext != null) {
                StaticClientTokenContext.setClientTokenContext(tokenContext);
            }
            Object object = super.performInvocation(exchange, serviceObject, m, paramArray);
            return object;
        }
        catch (InvocationTargetException ex) {
            ClientAccessToken accessToken;
            String refreshToken;
            if (tokenContext != null && ex.getCause() instanceof NotAuthorizedException && (refreshToken = (accessToken = tokenContext.getToken()).getRefreshToken()) != null) {
                accessToken = OAuthClientUtils.refreshAccessToken(this.accessTokenServiceClient, this.consumer, accessToken);
                MessageContextImpl mc = new MessageContextImpl(inMessage);
                ((ClientTokenContextImpl)tokenContext).setToken(accessToken);
                this.clientTokenContextManager.setClientTokenContext((MessageContext)mc, tokenContext);
                Object object = super.performInvocation(exchange, serviceObject, m, paramArray);
                return object;
            }
            throw ex;
        }
        finally {
            if (tokenContext != null) {
                StaticClientTokenContext.removeClientTokenContext();
            }
        }
    }

    public void setAccessTokenServiceClient(WebClient accessTokenServiceClient) {
        this.accessTokenServiceClient = accessTokenServiceClient;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public void setClientTokenContextManager(ClientTokenContextManager clientTokenContextManager) {
        this.clientTokenContextManager = clientTokenContextManager;
    }
}

